/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.ProjectsManagerUI;
import csbase.client.applications.projectsmanager.models.ProjectHistoryBlockType;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.awt.Window;
import java.rmi.RemoteException;
import java.util.List;

public class UserRemovalFromProjectTask
extends ProjectsManagerTask<Boolean> {
    private List<ProjectsManagerData> projects;

    public UserRemovalFromProjectTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects) {
        super(projectsManager);
        this.projects = projects;
    }

    protected void performTask() {
        boolean error = false;
        ProjectsManager projectsManager = this.getProjectsManager();
        User user = projectsManager.getUser();
        Object currentUserID = user.getId();
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (ProjectsManagerData prj : this.projects) {
            try {
                CommonClientProject ccp = psi.openProject(prj.getProjectId(), false);
                ProjectsManagerUI.addAutomaticHistoryBlock(ccp, ProjectHistoryBlockType.PROJECT_SELF_REMOVAL);
                if (!ccp.removeUser(currentUserID)) {
                    error = true;
                }
                ccp.close(false);
            }
            catch (RemoteException e) {
                StandardErrorDialogs.showErrorDialog((Window)projectsManager.getApplicationFrame(), e);
                error = true;
            }
        }
        projectsManager.refreshProjectsTable();
        this.setResult(!error);
    }
}

