/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.diskusageservice.DiskOccupation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class ProjectInfoDialog
extends DesktopComponentDialog {
    private final JTextField nameText = new JTextField(15);
    private final JTextField descriptionText = new JTextField(15);
    private final JTextField userText = new JTextField(15);
    private final JTextField userNameText = new JTextField(20);
    private final JTextField serverOwnerText = new JTextField(15);
    private final JTextField usageText = new JTextField(15);
    private final JTextField freeText = new JTextField(15);

    private final String getString(String tag) {
        String className = this.getClass().getSimpleName();
        return LNG.get((String)(className + "." + tag));
    }

    protected JPanel buildMainPanel() {
        JLabel nameLabel = new JLabel(this.getString("name.label"));
        JLabel descriptionLabel = new JLabel(this.getString("description.label"));
        JLabel usageLabel = new JLabel(this.getString("usage.label"));
        JLabel freeLabel = new JLabel(this.getString("free.label"));
        JLabel userLabel = new JLabel(this.getString("user.label"));
        JLabel userNameLabel = new JLabel(this.getString("user.name.label"));
        JLabel serverOwnerLabel = new JLabel(this.getString("server.owner.label"));
        this.userText.setEditable(false);
        this.nameText.setEditable(false);
        this.descriptionText.setEditable(false);
        this.usageText.setEditable(false);
        this.freeText.setEditable(false);
        this.userNameText.setEditable(false);
        this.serverOwnerText.setEditable(false);
        this.usageText.setHorizontalAlignment(4);
        this.freeText.setHorizontalAlignment(4);
        JComponent[][] cmps = new JComponent[][]{{nameLabel, this.nameText}, {descriptionLabel, this.descriptionText}, {userLabel, this.userText}, {userNameLabel, this.userNameText}, {serverOwnerLabel, this.serverOwnerText}, {new JLabel(" ")}, {usageLabel, this.usageText}, {freeLabel, this.freeText}};
        JPanel panel = GUIUtils.createBasicGridPanel((JComponent[][])cmps);
        return panel;
    }

    protected JPanel buildButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton closeButton = new JButton(this.getString("close.button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProjectInfoDialog.this.close();
            }
        });
        JButton refreshButton = new JButton(this.getString("refresh.button"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProjectInfoDialog.this.refresh();
            }
        });
        panel.add(refreshButton);
        panel.add(closeButton);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{refreshButton, closeButton});
        return panel;
    }

    public final void refresh() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        CommonClientProject prj = desktopFrame.getProject();
        String projName = prj.getName();
        final Object ownerId = prj.getUserId();
        this.nameText.setText(projName);
        this.descriptionText.setText(prj.getDescription());
        this.userText.setText(ownerId.toString());
        RemoteTask<String> task = new RemoteTask<String>(){

            protected void performTask() throws Exception {
                this.setResult(User.getName((Object)ownerId));
            }
        };
        if (task.execute(desktopFrame.getDesktopFrame(), this.getTitle(), this.getString("get.user.name.msg"))) {
            this.userNameText.setText((String)task.getResult());
        }
        this.serverOwnerText.setText(prj.getOwnerServerName());
        DiskOccupation occ = DiskUsageProxy.getCurrentProjectOccupation();
        if (!occ.isValid()) {
            this.usageText.setText("?");
            this.freeText.setText("?");
            return;
        }
        double freeMb = occ.getFreeSpaceMb();
        double usedMb = occ.getUsedSpaceMb();
        String usageStr = this.getText(usedMb);
        String freeStr = this.getText(freeMb);
        this.usageText.setText(usageStr);
        this.freeText.setText(freeStr);
    }

    private String getText(double spaceMb) {
        double value = spaceMb;
        String unit = "mb";
        if (value > 1024.0) {
            value /= 1024.0;
            unit = "gb";
            if (value > 1024.0) {
                value /= 1024.0;
                unit = "tb";
            }
        }
        DecimalFormat formatter = new DecimalFormat("0.00");
        String text = formatter.format(value) + " " + unit;
        return text;
    }

    public ProjectInfoDialog(DesktopFrame desktopFrame) {
        super((Window)desktopFrame.getDesktopFrame());
        this.setTitle(this.getString("title"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.buildMainPanel(), "Center");
        mainPanel.add((Component)this.buildButtonsPanel(), "South");
        Container container = this.getContentPane();
        container.add(mainPanel);
        this.pack();
        this.setResizable(false);
    }
}

