/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.imageviewer.actions.effects;

import csbase.client.applications.ApplicationComponentDialog;
import csbase.client.applications.imageviewer.ImageViewer;
import csbase.client.applications.imageviewer.effects.AbstractEffect;
import csbase.client.util.ClientUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public class ImageViewerEffectDialog<T extends AbstractEffect>
extends ApplicationComponentDialog<ImageViewer> {
    private final T effect;
    final JLabel srcLabel = new JLabel();
    final JLabel dstLabel = new JLabel();
    private final JButton okButton = new JButton();
    private final JButton resetButton = new JButton();

    ImageViewerEffectDialog(ImageViewer application, T effect) {
        super(application);
        this.effect = effect;
        ((AbstractEffect)this.effect).setPreviewLabel(this.dstLabel);
        this.setLayout(new BorderLayout());
        JPanel paramPanel = ((AbstractEffect)effect).getParameterPanel();
        if (paramPanel != null) {
            this.add((Component)paramPanel, "North");
            BorderUtil.setLinedBorder((JComponent)paramPanel);
        }
        this.add(this.createPreviewPanel(), "Center");
        this.add((Component)this.createButtonsPanel(), "South");
        this.setMinimumSize(new Dimension(450, 400));
        this.setSize(new Dimension(700, 500));
    }

    private Component createPreviewPanel() {
        this.dstLabel.setVerticalTextPosition(3);
        this.dstLabel.setHorizontalTextPosition(0);
        this.dstLabel.setHorizontalAlignment(0);
        this.dstLabel.setVerticalAlignment(0);
        this.srcLabel.setVerticalTextPosition(3);
        this.srcLabel.setHorizontalTextPosition(0);
        this.srcLabel.setHorizontalAlignment(0);
        this.srcLabel.setVerticalAlignment(0);
        JScrollPane srcPane = new JScrollPane(this.srcLabel);
        BorderUtil.setLowBorder((JComponent)srcPane);
        JScrollPane dstPane = new JScrollPane(this.dstLabel);
        BorderUtil.setLowBorder((JComponent)dstPane);
        JScrollBar vBar = srcPane.getVerticalScrollBar();
        BoundedRangeModel vModel = vBar.getModel();
        dstPane.getVerticalScrollBar().setModel(vModel);
        JScrollBar hBar = srcPane.getHorizontalScrollBar();
        BoundedRangeModel hModel = hBar.getModel();
        dstPane.getHorizontalScrollBar().setModel(hModel);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.add((Component)srcPane, new GBC(0, 0).both().weights(10.0, 10.0));
        panel.add((Component)new JLabel(), new GBC(1, 0).both().weights(1.0, 1.0));
        panel.add((Component)dstPane, new GBC(2, 0).both().weights(10.0, 10.0));
        BorderUtil.setLinedBorder((JComponent)panel);
        return panel;
    }

    @Override
    public void setVisible(boolean b) {
        ImageViewer application = this.getImageViewer();
        BufferedImage srcImg = application.getCurrentBufferedImage();
        if (srcImg == null) {
            return;
        }
        ImageIcon imageIcon = new ImageIcon(srcImg);
        this.srcLabel.setIcon(imageIcon);
        this.okButton.setVisible(true);
        this.resetButton.setVisible(true);
        ((AbstractEffect)this.effect).resetParameters();
        super.setVisible(b);
    }

    private ImageViewer getImageViewer() {
        ImageViewer application = (ImageViewer)this.getApplication();
        return application;
    }

    private JPanel createButtonsPanel() {
        final ImageViewer application = this.getImageViewer();
        final ImageViewerEffectDialog dialog = this;
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        JButton closeButton = new JButton(cancelAction);
        closeButton.setText(this.getString("ImageViewerEffectDialog.cancel.button"));
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ImageViewerEffectDialog.this.effect.applyImageTransformation();
                }
                catch (Exception ex) {
                    String title = dialog.getTitle();
                    String message = ex.getMessage();
                    StandardDialogs.showErrorDialog((Component)dialog, (String)title, (String)message);
                }
                dialog.setVisible(false);
                application.setSaveNeeded(true);
            }
        };
        this.okButton.setAction(okAction);
        this.okButton.setText(this.getString("ImageViewerEffectDialog.ok.button"));
        AbstractAction resetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageViewerEffectDialog.this.effect.resetParameters();
            }
        };
        this.resetButton.setAction(resetAction);
        this.resetButton.setText(this.getString("ImageViewerEffectDialog.reset.button"));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(1));
        buttonsPanel.add(closeButton);
        buttonsPanel.add(this.resetButton);
        buttonsPanel.add(new JPanel());
        buttonsPanel.add(new JPanel());
        buttonsPanel.add(new JPanel());
        buttonsPanel.add(this.okButton);
        JComponent[] buttons = new JButton[]{closeButton, this.resetButton, this.okButton};
        ClientUtilities.adjustEqualSizes(buttons);
        BorderUtil.setLinedBorder((JComponent)buttonsPanel);
        return buttonsPanel;
    }

    protected final void initPreview() {
        boolean updated = ((AbstractEffect)this.effect).updatePreview();
        if (updated) {
            this.okButton.setEnabled(true);
            this.resetButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
    }
}

