/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applicationmanager.resourcehelpers;

import csbase.client.preferences.editors.FavoriteAlgorithmsEditor;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GUIUtils;

public class AlgorithmSelectionDialog
extends JDialog {
    private final JList list = new JList();

    public AlgorithmSelectionDialog(Window owner) {
        this(owner, Arrays.asList(AlgorithmManagementProxy.getAllAlgorithmInfos(null, AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM)));
    }

    public AlgorithmSelectionDialog(Window owner, List<AlgorithmInfo> algorithmsList) {
        super(owner, "", Dialog.ModalityType.DOCUMENT_MODAL);
        Collections.sort(algorithmsList, new Comparator<AlgorithmInfo>(){

            @Override
            public int compare(AlgorithmInfo o1, AlgorithmInfo o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                return n1.compareTo(n2);
            }
        });
        this.initListAttributes(algorithmsList);
        this.setLayout(new BorderLayout());
        JButton okButton = new JButton(this.getClassString("ok.button"));
        JButton cancelButton = new JButton(this.getClassString("cancel.button"));
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{okButton, cancelButton});
        okButton.setEnabled(false);
        JPanel buttonsPanel = new JPanel(new FlowLayout(2));
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(okButton);
        JScrollPane pane = new JScrollPane(this.list);
        BorderUtil.setLowBorder((JComponent)pane);
        this.add((Component)pane, "Center");
        this.add((Component)buttonsPanel, "South");
        this.setLocationRelativeTo(this.getOwner());
        this.setUpButtons(okButton, cancelButton);
        this.setUpListeners(okButton);
        this.setMinimumSize(new Dimension(400, 300));
        this.pack();
    }

    private void initListAttributes(final List<AlgorithmInfo> algorithms) {
        this.list.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return algorithms.size();
            }

            @Override
            public Object getElementAt(int index) {
                return algorithms.get(index);
            }
        });
        this.list.setSelectionMode(2);
        this.list.setLayoutOrientation(0);
        this.list.setCellRenderer(this.buildCellRenderer());
    }

    private void setUpButtons(JButton okButton, JButton cancelButton) {
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmSelectionDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmSelectionDialog.this.setVisible(false);
                AlgorithmSelectionDialog.this.list.clearSelection();
            }
        });
    }

    private void setUpListeners(final JButton okButton) {
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                okButton.setEnabled(AlgorithmSelectionDialog.this.list.getSelectedValue() != null);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    okButton.doClick();
                }
            }
        });
    }

    public List<String> getSelectedAlgorithms() {
        if (this.list.getSelectedIndices() == null) {
            return null;
        }
        Object[] indices = this.list.getSelectedValues();
        ArrayList<String> algoriths = new ArrayList<String>(indices.length);
        for (Object obj : indices) {
            AlgorithmInfo algorithm = (AlgorithmInfo)obj;
            algoriths.add(algorithm.getId());
        }
        return algoriths;
    }

    private ListCellRenderer buildCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jlist, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)jlist, value, index, isSelected, cellHasFocus);
                AlgorithmInfo algorithm = (AlgorithmInfo)value;
                String id = algorithm.getId();
                ImageIcon icon = FavoriteAlgorithmsEditor.getIconForVersion(algorithm.getLastVersion());
                String name = algorithm.getName();
                this.setIcon(icon);
                this.setText(name);
                this.setHorizontalAlignment(10);
                return this;
            }
        };
    }

    private String getClassString(String key) {
        return LNG.get((String)(this.getClass().getSimpleName() + "." + key));
    }
}

