/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.desktoplauncher.panels.eventpanel;

import csbase.client.Client;
import csbase.client.applications.desktoplauncher.DesktopLauncherEvent;
import csbase.client.applications.desktoplauncher.DesktopLauncherEventDirection;
import csbase.client.applications.desktoplauncher.DesktopLauncherUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class EventRenderer
implements TableCellRenderer {
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private final Font DEFAULT_FONT = DEFAULT_RENDERER.getFont();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel label = (JLabel)renderer;
        label.setOpaque(true);
        label.setIcon(null);
        label.setHorizontalAlignment(2);
        label.setForeground(Color.black);
        label.setFont(this.DEFAULT_FONT);
        Client client = Client.getInstance();
        String myId = client.getClientInstanceId();
        DesktopLauncherEvent event = (DesktopLauncherEvent)value;
        String otherId = event.getOtherId();
        if (otherId != null && otherId.equals(myId)) {
            label.setForeground(Color.gray);
            label.setFont(this.DEFAULT_FONT.deriveFont(2));
        }
        if (column == 0) {
            Date date = event.getDate();
            label.setHorizontalAlignment(2);
            String text = DesktopLauncherUI.formatDate(date);
            label.setText(text);
            label.setIcon(null);
        } else if (column == 1) {
            DesktopLauncherEventDirection direction = event.getDirection();
            label.setHorizontalAlignment(0);
            label.setText(null);
            ImageIcon icon = DesktopLauncherUI.getDirectionIcon(direction);
            label.setIcon(icon);
        } else if (column == 2) {
            boolean treated = event.isTreated();
            label.setHorizontalAlignment(0);
            label.setText(null);
            ImageIcon icon = DesktopLauncherUI.getTreatedIcon(treated);
            label.setIcon(icon);
        } else if (column == 3) {
            label.setHorizontalAlignment(2);
            label.setText(otherId);
            label.setIcon(null);
        } else if (column == 4) {
            String typeName = event.getType();
            label.setHorizontalAlignment(2);
            label.setText(typeName);
            label.setIcon(null);
        } else if (column == 5) {
            String className = event.getClassName();
            label.setHorizontalAlignment(2);
            label.setText(className);
            label.setIcon(null);
        } else if (column == 6) {
            String valueText = event.getValueText();
            label.setHorizontalAlignment(2);
            label.setText(valueText);
            label.setIcon(null);
        }
        return label;
    }
}

