/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.jobmonitor.filters;

import csbase.client.applications.jobmonitor.JobMonitor;
import csbase.client.applications.jobmonitor.filters.JobInfoFilter;
import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.table.ColumnState;
import csbase.client.facilities.configurabletable.table.ConfigurableTable;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.gui.GBC;

public class FilteredTablePanel
extends JPanel {
    private JComboBox columnsComboBox;
    private JCheckBox wholeWordCheckBox;
    private JTextField filterField;
    private JobMonitor app;
    private ConfigurableTable<JobInfoRow> table;

    public FilteredTablePanel(JobMonitor app, ConfigurableTable<JobInfoRow> table) {
        super(new GridBagLayout());
        this.app = app;
        this.table = table;
        this.columnsComboBox = this.createComboBox();
        this.wholeWordCheckBox = this.createWholeWordCheckBox();
        this.filterField = this.createFilterField();
        JLabel filterLabel = new JLabel(app.getString("label.filter"));
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)filterLabel, new GBC(0, 0).west());
        filterPanel.add((Component)this.filterField, new GBC(1, 0).left(10).horizontal());
        filterPanel.add((Component)this.columnsComboBox, new GBC(2, 0).left(10).none());
        filterPanel.add((Component)this.wholeWordCheckBox, new GBC(3, 0).left(10).right(50).none());
        this.add((Component)filterPanel, new GBC(0, 0).horizontal());
        this.add((Component)new JScrollPane((Component)((Object)table)), new GBC(0, 1).both().top(10));
    }

    public JComboBox createComboBox() {
        Vector<String> items = new Vector<String>();
        items.add(this.app.getString("all.columns"));
        for (ColumnState columnState : this.table.getColumnsState()) {
            items.add(columnState.getColumnId());
        }
        JComboBox comboBox = new JComboBox(items);
        comboBox.setMaximumRowCount(items.size());
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredTablePanel.this.changeTableFilter();
            }
        });
        return comboBox;
    }

    private JTextField createFilterField() {
        JTextField field = new JTextField();
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilteredTablePanel.this.changeTableFilter();
            }
        });
        return field;
    }

    private JCheckBox createWholeWordCheckBox() {
        JCheckBox checkBox = new JCheckBox(this.app.getString("label.whole.word"));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilteredTablePanel.this.changeTableFilter();
            }
        });
        return checkBox;
    }

    private void changeTableFilter() {
        try {
            String regex = this.filterField.getText();
            Pattern newPattern = Pattern.compile(regex);
            int selectedIndex = this.columnsComboBox.getSelectedIndex();
            LinkedList<String> columnsToFilter = new LinkedList<String>();
            JobInfoFilter filter = (JobInfoFilter)this.table.getFilter();
            if (selectedIndex == 0) {
                for (ColumnState columnState : this.table.getColumnsState()) {
                    columnsToFilter.add(columnState.getColumnId());
                }
            } else {
                columnsToFilter.add(this.columnsComboBox.getSelectedItem().toString());
            }
            filter.setPattern(newPattern);
            filter.setColumnsToFilter(columnsToFilter);
            filter.setWholeWord(this.wholeWordCheckBox.isSelected());
            this.table.updateRows();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

