/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.preferenceviewer;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.preferenceviewer.PreferencePanel;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferencePolicy;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class PreferenceViewer
extends Application {
    private PreferencePanel mainPanel = new PreferencePanel(this);

    public PreferenceViewer(String id) {
        super(id);
        this.buildInterface();
    }

    @Override
    public void killApplication() throws ApplicationException {
        this.mainPanel.removeAllListeners();
    }

    @Override
    protected boolean userCanKillApplication() {
        return true;
    }

    @Override
    public void sendMessage(String name, Object value, String senderId) {
        if ("PREFERENCE_MESSAGE".equals(name) && value != null) {
            this.mainPanel.rebuidInterface((PreferenceCategory)value);
        }
    }

    private void buildInterface() {
        ApplicationFrame appFrame = this.getApplicationFrame();
        appFrame.setLayout(new GridBagLayout());
        JButton ok = this.createOkButton();
        JButton cancel = this.createCancelButton();
        JRootPane rootPane = appFrame.getRootPane();
        rootPane.setDefaultButton(ok);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{ok, cancel, this.mainPanel.getRestoreButton()});
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        buttonsPanel.add((Component)new JLabel(), new GBC(1, 0).horizontal());
        buttonsPanel.add((Component)cancel, new GBC(2, 0).insets(5).east());
        buttonsPanel.add((Component)ok, new GBC(3, 0).insets(5).east());
        appFrame.add((Component)this.mainPanel, new GBC(0, 0).both().left(10).right(10).top(10));
        appFrame.add((Component)new JSeparator(0), new GBC(0, 1).horizontal());
        appFrame.add((Component)buttonsPanel, new GBC(0, 2).horizontal().left(10).right(10));
        appFrame.pack();
    }

    private JButton createCancelButton() {
        JButton cancel = new JButton(this.getString("button.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferenceViewer.this.closeApplication();
            }
        });
        return cancel;
    }

    private <T> JButton createOkButton() {
        JButton ok = new JButton("Ok");
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PreferenceCategory pc : PreferenceViewer.this.mainPanel.getModifiedCategories()) {
                    for (PreferenceValue<?> pv : pc.getPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE)) {
                        pv.getEditor().commit();
                    }
                    if (!pc.isCopy() || !PreferenceViewer.this.mainPanel.saveLocalPreferences()) continue;
                    PreferenceCategory originalPc = pc.getOriginal();
                    Iterator<PreferenceValue<?>> iterator = pc.getPreferences(PreferencePolicy.READ_ONLY, PreferencePolicy.READ_WRITE).iterator();
                    while (iterator.hasNext()) {
                        PreferenceValue<?> pv;
                        PreferenceValue<?> copyPv = pv = iterator.next();
                        PreferenceValue<?> originalPv = originalPc.getPreference(copyPv.getName());
                        originalPv.setValue(copyPv.getValue());
                    }
                }
                PreferenceManager.getInstance().savePreferences(PreferenceViewer.this.getApplicationFrame());
                PreferenceViewer.this.closeApplication();
            }
        });
        return ok;
    }
}

