/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.xmlviewer.actions;

import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.xmlviewer.XMLViewer;
import csbase.client.applications.xmlviewer.actions.core.XMLViewerAbstractOpenAction;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.exception.PermissionException;
import java.awt.Component;
import java.util.List;
import tecgraf.javautils.gui.StandardDialogs;

public class XMLViewerLocalOpenAction
extends XMLViewerAbstractOpenAction {
    private ClientLocalFile lastDirectory = null;

    public XMLViewerLocalOpenAction(XMLViewer application) {
        super(application, ApplicationImages.ICON_OPEN_LOCAL_16);
    }

    @Override
    protected final ClientLocalFile getFileForOpen() {
        String title;
        List<String> fileCodes;
        XMLViewer application = (XMLViewer)this.getApplication();
        ApplicationFrame window = application.getApplicationFrame();
        ClientLocalFile clientLocalFile = ClientLocalFileChooserUtil.browseSingleFileInOpenMode(window, fileCodes = application.getFileTypes(), title = application.getName(), true, this.lastDirectory);
        if (clientLocalFile == null) {
            return null;
        }
        if (!clientLocalFile.exists()) {
            String err = this.getString("XMLViewerLocalOpenAction.file.not.found.error", new Object[0]);
            StandardDialogs.showErrorDialog((Component)window, (String)title, (String)err);
            return null;
        }
        try {
            this.lastDirectory = clientLocalFile.getParent();
        }
        catch (PermissionException permissionException) {
            // empty catch block
        }
        return clientLocalFile;
    }
}

