/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.DesktopTask;
import csbase.client.remote.srvproxies.MailProxy;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import csbase.logic.UserNotification;
import csbase.util.messages.Message;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

abstract class AbstractNotificationFrame
extends DesktopComponentDialog {
    protected final JTextArea editionArea = new JTextArea();
    protected final JButton sendButton = new JButton(LNG.get((String)"notification.send.button"));
    protected final JCheckBox mailToggle = new JCheckBox();
    protected final JCheckBox popUpToggle = new JCheckBox();
    protected final JButton closeButton = new JButton(LNG.get((String)"notification.cancel.button"));

    protected void buildUI() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                AbstractNotificationFrame.this.close();
            }
        });
        this.setTitle(this.getWindowTitle());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.addSubPanels(contentPane);
        this.pack();
    }

    protected abstract void preShowInit();

    protected abstract String getWindowTitle();

    public void start() {
        this.mailToggle.setSelected(false);
        this.popUpToggle.setSelected(false);
        this.editionArea.setText("");
        this.preShowInit();
        DesktopFrame desktop = DesktopFrame.getInstance();
        DesktopComponentFrame desktopFrame = desktop.getDesktopFrame();
        this.center(desktopFrame);
        this.setVisible(true);
    }

    protected abstract void addSubPanels(Container var1);

    protected JPanel createEditionPanel(String title) {
        this.editionArea.setColumns(40);
        this.editionArea.setRows(10);
        this.editionArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractNotificationFrame.this.messageTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractNotificationFrame.this.messageTextChanged();
            }
        });
        JPanel editionPanel = new JPanel(new GridBagLayout());
        editionPanel.setBorder(BorderFactory.createTitledBorder(title));
        JScrollPane scrollEdition = new JScrollPane(this.editionArea);
        this.mailToggle.setText(LNG.get((String)"notification.mail.option"));
        this.mailToggle.setSelected(false);
        this.popUpToggle.setText(LNG.get((String)"notification.pop_up.option"));
        this.popUpToggle.setSelected(false);
        Insets border = new Insets(0, 5, 0, 5);
        editionPanel.add((Component)this.mailToggle, new GBC(0, 0).northwest().insets(border));
        editionPanel.add((Component)this.popUpToggle, new GBC(0, 1).northwest().insets(border));
        editionPanel.add((Component)scrollEdition, new GBC(0, 2).northwest().both().insets(10));
        return editionPanel;
    }

    protected void sendMessage(boolean isVolatile) {
        DesktopFrame imf = DesktopFrame.getInstance();
        if (imf == null) {
            return;
        }
        User loggedUser = User.getLoggedUser();
        if (loggedUser == null) {
            return;
        }
        String content = this.editionArea.getText();
        if (content.trim().isEmpty()) {
            StandardDialogs.showErrorDialog((Component)this, null, (String)LNG.get((String)"notification.no.message.error"));
            this.editionArea.requestFocus();
            return;
        }
        List<Object> users = this.getRecipientsIDs();
        final String[] usersLogin = users.toArray(new String[0]);
        UserNotification notification = new UserNotification(loggedUser.getLogin(), content, this.popUpToggle.isSelected(), isVolatile);
        final Message message = new Message((Serializable)notification);
        DesktopTask task = new DesktopTask(){

            @Override
            public void performTask() throws Exception {
                MessageProxy.send(message, usersLogin);
            }
        };
        task.start(DesktopFrame.getInstance().getDesktopFrame(), LNG.get((String)"notification.send.title"), LNG.get((String)"notification.send.message"));
        String snd = null;
        String[] emails = loggedUser.getEmails();
        snd = emails == null || emails.length == 0 ? loggedUser.getLogin() : emails[0];
        boolean mailedAllUsers = true;
        for (Object userID : users) {
            if (!this.mailToggle.isSelected() || MailProxy.mailTo(snd, userID, content, false)) continue;
            mailedAllUsers = false;
        }
        if (!mailedAllUsers) {
            DesktopComponentFrame jFrame = imf.getDesktopFrame();
            StandardErrorDialogs.showErrorDialog((Window)jFrame, LNG.get((String)"notification.failure.title"), LNG.get((String)"notification.failure.mail.msg"));
        }
        this.close();
    }

    protected abstract List<Object> getRecipientsIDs();

    public boolean hasMessage() {
        String content = this.editionArea.getText();
        return !content.trim().isEmpty();
    }

    protected abstract boolean hasRecipients();

    public void messageTextChanged() {
    }

    protected abstract ActionListener getSendButtonActionListener();

    protected ActionListener getCloseButtonActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int option;
                if (!AbstractNotificationFrame.this.editionArea.getText().trim().isEmpty() && (option = StandardDialogs.showYesNoDialog((Component)AbstractNotificationFrame.this, null, (Object)LNG.get((String)"notification.question.discardContent"))) == 1) {
                    return;
                }
                AbstractNotificationFrame.this.close();
            }
        };
    }

    protected JPanel createButtonsPane(boolean addSendButton) {
        this.closeButton.addActionListener(this.getCloseButtonActionListener());
        this.sendButton.addActionListener(this.getSendButtonActionListener());
        ClientUtilities.adjustEqualSizes(this.closeButton, this.sendButton);
        JPanel panel = new JPanel(new FlowLayout());
        if (addSendButton) {
            panel.add(this.sendButton);
        }
        panel.add(this.closeButton);
        return panel;
    }

    protected JPanel createButtonsPane() {
        return this.createButtonsPane(true);
    }

    public AbstractNotificationFrame() {
        super((Window)null);
        this.setModalityType(Dialog.ModalityType.MODELESS);
    }
}

