/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.Client;
import csbase.client.ClientServerManager;
import csbase.client.ClientUI;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.executor.ExecutorFrame;
import csbase.client.desktop.BasicNotificationPanel;
import csbase.client.desktop.CommandNotificationHandler;
import csbase.client.desktop.CommandPersistenceCommandNotificationHandler;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrameOpenBusEventHandler;
import csbase.client.desktop.DesktopPref;
import csbase.client.desktop.DesktopWindowInterface;
import csbase.client.desktop.NotificationPanel;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.TreeFilterPanel;
import csbase.client.desktop.TreeFilterPanelListener;
import csbase.client.desktop.dircontents.DirectoryContentsPanel;
import csbase.client.ias.AdminFrame;
import csbase.client.kernel.ClientException;
import csbase.client.login.InitialContext;
import csbase.client.preferences.PreferenceCategory;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVBoolean;
import csbase.client.preferences.types.PVDimension;
import csbase.client.preferences.types.PVInteger;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeAdapter;
import csbase.client.project.RecentProjectsManager;
import csbase.client.project.action.OneProjectOpenAction;
import csbase.client.project.action.ProjectCloseAction;
import csbase.client.project.action.ShowTreeFilterAction;
import csbase.client.project.dialogs.ProjectBuildingDialog;
import csbase.client.project.tasks.OpenProjectOnTreeRemoteTask;
import csbase.client.remote.AdministrationObserver;
import csbase.client.remote.AlgorithmManagementObserver;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.ClientRemoteMonitorListener;
import csbase.client.remote.ProjectAdminObserver;
import csbase.client.remote.manager.server.ServerInfoManager;
import csbase.client.remote.srvproxies.EventLogProxy;
import csbase.client.remote.srvproxies.NotificationProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ConfigurationException;
import csbase.logic.CommonClientProject;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ProjectAdminInfo;
import csbase.logic.ProjectBasicInfo;
import csbase.logic.Session;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.logic.filetypefinder.FileTypeFinder;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class DesktopFrame
implements ClientUI {
    private static final String PROJECT_NAME_ATTRIBUTE = "project_name";
    private static final String ALGORITHM_NAME_ATTRIBUTE = "algorithm_name";
    private static final String ALGORITHM_PARAMETERS_ATTRIBUTE = "algorithm_parameters";
    private static final int MAX_RECENT_PROJECTS = 10;
    private static String[] desktopQueue = new String[]{"Desktop"};
    private static DesktopFrame instance = null;
    private static JCheckBoxMenuItem projectAutoUpdateItem;
    private Boolean autoUpdateProjectTree;
    private static JCheckBoxMenuItem showTreeFilterItem;
    private static JCheckBoxMenuItem showTrayIconItem;
    protected AdminFrame adminFrame;
    protected DirectoryContentsPanel dirContentsPanel;
    protected NotificationPanel notifPanel;
    protected JComponent projectTreePanel;
    protected JSplitPane splitPaneBetweenTreeAndTable;
    protected JSplitPane splitPaneBetweenTreeAndApp;
    protected JSplitPane splitPaneBetweenAppAndNotif;
    protected ProjectTree projectTree;
    private MenuItem defaultExitTrayMenuItem;
    private CheckboxMenuItem defaultVisibilityTrayCheckMenuItem;
    private Vector<DesktopWindowInterface> dependentWindows = null;
    private DesktopComponentFrame mainFrame = null;
    protected MonitoredServerListener connMonitorListener;
    private Image errorImage = null;
    private Configuration configuration;
    protected TreeFilterPanel treeFilterPanel;
    private Boolean showHiddenFiles;
    private Boolean expandDataset;
    private TrayIcon trayIcon;
    private DesktopFrameOpenBusEventHandler eventHandler;

    private void shutdownDependents() {
        int base = 0;
        DesktopWindowInterface lastWindow = null;
        while (this.dependentWindows.size() > 0) {
            DesktopWindowInterface window = this.dependentWindows.get(base);
            if (window == lastWindow) {
                ++base;
                continue;
            }
            window.close();
            lastWindow = window;
        }
    }

    public String adjustTitle(String title) {
        return title;
    }

    protected final void setTitle(String title) {
        this.mainFrame.setTitle(title);
    }

    public String getTitle() {
        return this.mainFrame.getTitle();
    }

    public void setFrameImage(Image image) {
        this.mainFrame.setIconImage(image);
    }

    public Image getDesktopErrorImage() {
        return this.errorImage;
    }

    public void setDesktopErrorImage(Image image) {
        this.errorImage = image;
    }

    public Image getFrameImage() {
        return this.mainFrame.getIconImage();
    }

    public void setMenuBar(JMenuBar menuBar) {
        this.mainFrame.setJMenuBar(menuBar);
    }

    public JMenuBar getMenuBar() {
        JMenuBar menuBar = this.mainFrame.getJMenuBar();
        return menuBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDesktop() {
        Object dp;
        if (this.eventHandler != null) {
            this.eventHandler.shutdown();
        }
        ClientRemoteMonitor clientRemoteMonitor = ClientRemoteMonitor.getInstance();
        clientRemoteMonitor.deleteListener(this.connMonitorListener);
        EventLogProxy.addClientInformation(desktopQueue, "logout");
        String[] queue = new String[]{"Idiom"};
        String[] msg = new String[]{"Textos sem chave em qualquer idioma:\n", Client.getInstance().getTextNotFoundInAnyIdiom()};
        EventLogProxy.addClientInformation(queue, msg);
        msg = new String[]{"Textos sem chave no idioma " + LNG.getLocale() + ":\n", Client.getInstance().getTextNotFoundInSelectedIdiom()};
        EventLogProxy.addClientInformation(queue, msg);
        ApplicationManager appManager = ApplicationManager.getInstance();
        appManager.finishAllApplications();
        this.shutdownDependents();
        this.stopServicesObservers();
        if (clientRemoteMonitor.isAlive()) {
            dp = this.getDesktopPreferences();
            if (((PreferenceCategory)dp).getPreferenceAsBoolean(DesktopPref.SAVE_STATE).booleanValue()) {
                this.saveDesktopPreferences();
            }
            ClientServerManager.getInstance().shutdown();
        }
        this.mainFrame.setVisible(false);
        this.mainFrame.close();
        dp = instance;
        synchronized (dp) {
            instance = null;
        }
        Client client = Client.getInstance();
        client.shutdown();
    }

    protected void configureDesktop() {
        PreferenceCategory dp = this.getDesktopPreferences();
        PVDimension size = (PVDimension)dp.getPreference(DesktopPref.SIZE);
        this.setDesktopSize((Dimension)size.getValue());
        if (dp.getPreferenceAsBoolean(DesktopPref.MAXIMIZED).booleanValue()) {
            this.maximizeDesktop();
        }
        int dividerAppNotif = dp.getPreferenceAsInt(DesktopPref.DIV_APP_NOTIF);
        int dividerTreeTable = dp.getPreferenceAsInt(DesktopPref.DIV_TREE_TABLE);
        int dividerTreeApp = dp.getPreferenceAsInt(DesktopPref.DIV_TREE_APP);
        this.splitPaneBetweenAppAndNotif.setDividerLocation(dividerAppNotif);
        this.splitPaneBetweenTreeAndTable.setDividerLocation(dividerTreeTable);
        this.splitPaneBetweenTreeAndApp.setDividerLocation(dividerTreeApp);
    }

    protected void saveDesktopPreferences() {
        PreferenceCategory dp = this.getDesktopPreferences();
        PVDimension size = (PVDimension)dp.getPreference(DesktopPref.SIZE);
        size.setValue(new Dimension(this.mainFrame.getSize().width, this.mainFrame.getSize().height));
        PVBoolean maximized = dp.getPVBoolean(DesktopPref.MAXIMIZED);
        maximized.setValue(this.mainFrame.getExtendedState() == 6);
        PVInteger dividerAppNotif = dp.getPVInteger(DesktopPref.DIV_APP_NOTIF);
        dividerAppNotif.setValue(this.splitPaneBetweenAppAndNotif.getDividerLocation());
        PVInteger dividerTreeTable = dp.getPVInteger(DesktopPref.DIV_TREE_TABLE);
        dividerTreeTable.setValue(this.splitPaneBetweenTreeAndTable.getDividerLocation());
        PVInteger dividerTreeApp = dp.getPVInteger(DesktopPref.DIV_TREE_APP);
        dividerTreeApp.setValue(this.splitPaneBetweenTreeAndApp.getDividerLocation());
        PreferenceManager.getInstance().savePreferences();
    }

    protected PreferenceCategory getDesktopPreferences() {
        PreferenceManager pm = PreferenceManager.getInstance();
        PreferenceCategory allPrefs = pm.loadPreferences();
        return allPrefs.getCategory(DesktopPref.class);
    }

    public boolean mustUpdateProjectTree() {
        if (this.autoUpdateProjectTree != null) {
            return this.autoUpdateProjectTree;
        }
        PreferenceCategory dp = this.getDesktopPreferences();
        return dp.getPreferenceAsBoolean(DesktopPref.AUTO_UPDATE);
    }

    public void addWindow(DesktopWindowInterface win) {
        this.dependentWindows.add(win);
    }

    public void removeWindow(DesktopWindowInterface win) {
        this.dependentWindows.remove(win);
    }

    public DesktopComponentFrame getDesktopFrame() {
        return this.mainFrame;
    }

    public boolean userHasProject() {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                this.setResult(CommonClientProject.userHasHisOwnProjects((Object)User.getLoggedUser().getId()));
            }
        };
        if (!task.execute(this.getDesktopFrame(), this.getTitle(), LNG.get((String)"DesktopFrame.info.checkIfUserHasProject"))) {
            return false;
        }
        return (Boolean)task.getResult();
    }

    public boolean userHasOthersProject() {
        try {
            User loggedUser = User.getLoggedUser();
            return CommonClientProject.userParticipatesOnSharedProjects((Object)loggedUser.getId());
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.getDesktopFrame(), this.getTitle(), (Throwable)e);
            return false;
        }
    }

    protected void enableIfProject(final JComponent item) {
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectRemoved() {
                item.setEnabled(DesktopFrame.this.userHasProject());
            }
        });
    }

    public final FileTypeFinder getFileTypeFinder() {
        return this.projectTree.getFileTypeFinder();
    }

    protected void enableIfProjectOpened(final JComponent item) {
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                item.setEnabled(project != null);
            }
        });
    }

    protected void enableIfAdminProject(final JMenuItem item) {
        this.projectTree.addProjectTreeListener(new ProjectTreeAdapter(){

            @Override
            public void projectChanged(CommonClientProject project) {
                item.setEnabled(project != null && (project.getUserId().equals(User.getLoggedUser().getId()) || User.getLoggedUser().isAdmin()));
            }
        });
    }

    public static DesktopFrame getInstance() {
        return instance;
    }

    protected void showDesktop() {
        this.configureDesktop();
        Client client = Client.getInstance();
        boolean visibleDesktop = client.shouldDesktopStartVisible();
        this.mainFrame.setVisible(visibleDesktop);
        if (!visibleDesktop) {
            this.displayTrayInfoMessage(client.getSystemName());
        }
        this.updateVisibilityTrayCheckMenuItem();
        EventLogProxy.addClientInformation(desktopQueue, "login");
        Object startProject = client.startProjectId();
        if (startProject != null) {
            CommonClientProject startedProject = this.openProject(startProject);
            if (startedProject == null) {
                this.openLastProject();
            }
        } else {
            this.openLastProject();
        }
        this.runStartApplication(client);
    }

    private void openLastProject() {
        PreferenceCategory dp = this.getDesktopPreferences();
        if (dp.getPreferenceAsBoolean(DesktopPref.OPEN_LAST_PROJECT).booleanValue()) {
            Object lastProjectId = this.getLastOpenedProjectId();
            if (lastProjectId == null) {
                return;
            }
            if (!this.checkOpenableProject(lastProjectId)) {
                return;
            }
            this.openProject(lastProjectId);
        }
    }

    private Object getLastOpenedProjectId() {
        Collection<ProjectBasicInfo> recentProjects = this.getRecentProjects();
        if (recentProjects == null || recentProjects.size() == 0) {
            return null;
        }
        ProjectBasicInfo lastProjectInfo = (ProjectBasicInfo)((LinkedList)recentProjects).peek();
        if (lastProjectInfo == null) {
            return null;
        }
        return lastProjectInfo.getProjectId();
    }

    private void runStartApplication(Client client) {
        String appId = client.getStartApplicationId();
        if (appId == null) {
            return;
        }
        ApplicationManager appManager = ApplicationManager.getInstance();
        ApplicationRegistry reg = appManager.getApplicationRegistry(appId);
        if (reg == null) {
            String tag = "DesktopFrame.undefined.start.application.failure";
            String fmt = LNG.get((String)"DesktopFrame.undefined.start.application.failure");
            String err = String.format(fmt, appId);
            StandardErrorDialogs.showErrorDialog((Window)this.getDesktopFrame(), err);
            return;
        }
        Locale locale = LNG.getLocale();
        try {
            CommonClientProject project = this.getProject();
            if (reg.requireProject() && project == null) {
                String tag = "DesktopFrame.project.start.application.failure";
                String fmt = LNG.get((String)"DesktopFrame.project.start.application.failure");
                String err = String.format(fmt, reg.getApplicationName(locale));
                StandardErrorDialogs.showErrorDialog((Window)this.getDesktopFrame(), err);
                return;
            }
            appManager.runApplication(appId);
        }
        catch (ApplicationException e) {
            String fmt = LNG.get((String)"DesktopFrame.start.application.failure");
            String err = String.format(fmt, reg.getApplicationName(locale));
            StandardErrorDialogs.showErrorDialog((Window)this.getDesktopFrame(), err, (Throwable)e);
        }
    }

    private void setDesktopSize(Dimension dimension) {
        this.mainFrame.pack();
        this.mainFrame.setExtendedState(0);
        this.mainFrame.setSize(dimension);
        this.mainFrame.validate();
    }

    private void maximizeDesktop() {
        this.mainFrame.pack();
        this.mainFrame.setExtendedState(6);
        this.mainFrame.validate();
    }

    public CommonClientProject getProject() {
        return this.projectTree == null ? null : this.projectTree.getProject();
    }

    public ProjectTree getTree() {
        return this.projectTree;
    }

    protected void startServicesObservers() throws ClientException {
        try {
            AdministrationObserver.start();
            ProjectAdminObserver.start();
            AlgorithmManagementObserver.start();
            if (ServerInfoManager.getInstance().isEnabled()) {
                ServerInfoManager.getInstance().start();
            }
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    protected void stopServicesObservers() {
        try {
            if (ServerInfoManager.getInstance().isEnabled()) {
                ServerInfoManager.getInstance().stop();
            }
        }
        catch (Exception e) {
            System.out.println("Falha ao remover os observadores: " + e.getMessage());
        }
    }

    protected Image getDesktopFrameIcon() {
        String iconPath = this.configuration.getOptionalProperty("iconPath");
        if (iconPath == null) {
            return null;
        }
        URL url = this.getClass().getResource(iconPath);
        ImageIcon imageIcon = new ImageIcon(url);
        Image image = imageIcon.getImage();
        return image;
    }

    public DesktopFrame() throws ClientException {
        if (instance != null) {
            throw new ClientException("Double Desktop!");
        }
        final Locale locale = LNG.getLocale();
        RemoteTask<Void> initTask = new RemoteTask<Void>(){

            protected void performTask() throws RemoteException {
                ApplicationManager.setInstance(locale);
            }
        };
        DesktopComponentFrame dskFrame = this.getDesktopFrame();
        String initMessage = LNG.get((String)"DesktopFrame.init.message");
        String initTitle = LNG.get((String)"DesktopFrame.init.title");
        boolean initExecuted = initTask.execute(dskFrame, initTitle, initMessage);
        if (!initExecuted) {
            Exception excpt = initTask.getError();
            String err = LNG.get((String)"DesktopFrame.init.error");
            throw new ClientException(err, excpt);
        }
        PreferenceManager prefManager = PreferenceManager.getInstance();
        prefManager.loadDefinition(DesktopPref.class);
        try {
            ConfigurationManager manager = ConfigurationManager.getInstance();
            this.configuration = manager.getConfiguration(this.getClass());
        }
        catch (ConfigurationManagerException e) {
            throw new ConfigurationException((Throwable)e);
        }
        this.dependentWindows = new Vector();
        this.mainFrame = new DesktopComponentFrame();
        this.mainFrame.setPreferredSize(new Dimension(800, 600));
        this.mainFrame.setDefaultCloseOperation(0);
        instance = this;
        this.startServicesObservers();
        Image desktopImage = this.getDesktopFrameIcon();
        if (desktopImage != null) {
            this.setFrameImage(desktopImage);
        }
    }

    public boolean isTrayIconSupported() {
        if (!SystemTray.isSupported()) {
            return false;
        }
        SystemTray tray = SystemTray.getSystemTray();
        return tray != null;
    }

    private TrayIcon mountTrayIcon() throws ClientException {
        if (!this.isTrayIconSupported()) {
            return null;
        }
        PreferenceCategory dp = this.getDesktopPreferences();
        TrayIcon tr = this.createTrayIcon();
        if (tr == null) {
            return null;
        }
        boolean showTrayIcon = dp.getPreferenceAsBoolean(DesktopPref.SHOW_TRAY_ICON);
        if (showTrayIcon) {
            try {
                SystemTray tray = SystemTray.getSystemTray();
                tray.add(tr);
                return tr;
            }
            catch (AWTException e) {
                e.printStackTrace();
                return null;
            }
        }
        return tr;
    }

    public final void setDesktopVisible(boolean shown) {
        DesktopComponentFrame frm = this.getDesktopFrame();
        ((Window)frm).setVisible(shown);
        if (this.eventHandler != null) {
            this.eventHandler.fireDesktopVisibilityInfo(shown);
        }
    }

    public final boolean isDesktopVisible() {
        DesktopComponentFrame frm = this.getDesktopFrame();
        return frm.isVisible();
    }

    protected final CheckboxMenuItem getDefaultVisibilityTrayCheckMenuItem() {
        return this.defaultVisibilityTrayCheckMenuItem;
    }

    protected final MenuItem getDefaultExitTrayMenuItem() {
        return this.defaultExitTrayMenuItem;
    }

    protected TrayIcon createTrayIcon() {
        if (this.trayIcon != null) {
            return this.trayIcon;
        }
        final DesktopFrame desktop = this;
        this.defaultExitTrayMenuItem = new MenuItem();
        this.defaultExitTrayMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                desktop.shutdownDesktop();
            }
        });
        String exitText = LNG.get((String)"DesktopFrame.tray.exit.item");
        this.defaultExitTrayMenuItem.setLabel(exitText);
        this.defaultVisibilityTrayCheckMenuItem = new CheckboxMenuItem();
        this.defaultVisibilityTrayCheckMenuItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean visible = DesktopFrame.this.isDesktopVisible();
                desktop.setDesktopVisible(!visible);
            }
        });
        String showText = LNG.get((String)"DesktopFrame.tray.visible.item");
        this.defaultVisibilityTrayCheckMenuItem.setLabel(showText);
        PopupMenu popup = new PopupMenu();
        popup.add(this.defaultVisibilityTrayCheckMenuItem);
        popup.addSeparator();
        popup.add(this.defaultExitTrayMenuItem);
        String tooltip = this.getTitle();
        Image desktopFrameIcon = this.getDesktopFrameIcon();
        Image errImage = ApplicationImages.ICON_ERROR_16.getImage();
        Image image = desktopFrameIcon == null ? errImage : desktopFrameIcon;
        TrayIcon tr = new TrayIcon(image, tooltip, popup);
        tr.setImageAutoSize(true);
        tr.setToolTip(LNG.get((String)"systemName"));
        DesktopComponentFrame frm = this.getDesktopFrame();
        frm.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                DesktopFrame.this.updateVisibilityTrayCheckMenuItem();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                DesktopFrame.this.updateVisibilityTrayCheckMenuItem();
            }
        });
        return tr;
    }

    private void updateVisibilityTrayCheckMenuItem() {
        boolean visible = this.isDesktopVisible();
        if (this.defaultVisibilityTrayCheckMenuItem != null) {
            this.defaultVisibilityTrayCheckMenuItem.setState(visible);
        }
    }

    @Override
    public void preInitialization(InitialContext initialContext) {
        this.connMonitorListener = new ClientRemoteMonitorListener(this.mainFrame);
        ClientServerManager.getInstance().addCommonListener(this.connMonitorListener);
    }

    @Override
    public void showUI() {
        try {
            this.trayIcon = this.mountTrayIcon();
            this.adjustTrayIcon();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        this.showDesktop();
    }

    protected void adjustTrayIcon() {
    }

    @Override
    public void postInitialization() {
        Client client = Client.getInstance();
        if (client.isOpenBusNeeded()) {
            this.eventHandler = new DesktopFrameOpenBusEventHandler(this);
        }
        if (this.loadProject()) {
            this.executeAlgorithm();
        }
    }

    @Override
    public JFrame getView() {
        return this.getDesktopFrame();
    }

    private void executeAlgorithm() {
        ClientRemoteMonitor clientRemoteMonitor = ClientRemoteMonitor.getInstance();
        Session session = clientRemoteMonitor.getSession();
        String algorithmName = (String)((Object)session.getAttribute(ALGORITHM_NAME_ATTRIBUTE));
        if (algorithmName == null) {
            return;
        }
        Map algorithmParameters = (Map)((Object)session.getAttribute(ALGORITHM_PARAMETERS_ATTRIBUTE));
        try {
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            ExecutorFrame executorFrame = (ExecutorFrame)applicationManager.runApplication("executor");
            executorFrame.showConfigurator(algorithmName, algorithmParameters);
        }
        catch (ApplicationException e) {
            StandardErrorDialogs.showErrorDialog((Window)this.getDesktopFrame(), e);
        }
    }

    private boolean loadProject() {
        String projectName = (String)((Object)ClientRemoteMonitor.getInstance().getSession().getAttribute(PROJECT_NAME_ATTRIBUTE));
        if (projectName == null) {
            return false;
        }
        this.openProject(projectName);
        return true;
    }

    public boolean checkOpenableProject(final Object projectId) {
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                ProjectServiceInterface psi = ClientRemoteLocator.projectService;
                if (psi.existsProject(projectId)) {
                    ProjectAdminInfo projectAdminInfo = psi.getProjectAdminInfo(projectId);
                    if (projectAdminInfo == null) {
                        this.setResult(true);
                    } else {
                        this.setResult(projectAdminInfo.isUnlockedWithAreaAllocated());
                    }
                } else {
                    this.setResult(false);
                }
            }

            @Override
            protected void handleError(Exception error) {
                error.printStackTrace();
            }
        };
        task.execute(this.getView(), LNG.get((String)"DesktopFrame.checking.project.blocked.title"), LNG.get((String)"DesktopFrame.checking.project.blocked.msg"));
        if (task.wasCancelled()) {
            StandardDialogs.showErrorDialog((Component)this.getView(), (String)LNG.get((String)"DesktopFrame.cancelled.task.title"), (String)LNG.get((String)"DesktopFrame.cancelled.task.msg"));
            return false;
        }
        if (!task.getStatus()) {
            StandardDialogs.showErrorDialog((Component)this.getView(), (String)LNG.get((String)"DesktopFrame.locked.project.failure.title"), (String)LNG.get((String)"DesktopFrame.locked.project.failure.msg"));
            return false;
        }
        boolean openable = (Boolean)task.getResult();
        if (!openable) {
            StandardDialogs.showErrorDialog((Component)this.getView(), (String)LNG.get((String)"DesktopFrame.locked.project.title"), (String)LNG.get((String)"DesktopFrame.locked.project.msg"));
        }
        return openable;
    }

    public CommonClientProject openProject(Object projectId) {
        ProjectCloseAction closeAction;
        CommonClientProject project = this.projectTree.getProject();
        if (project != null && !(closeAction = new ProjectCloseAction(this.projectTree)).close()) {
            return null;
        }
        OpenProjectOnTreeRemoteTask openProjectTask = new OpenProjectOnTreeRemoteTask(projectId, this.projectTree);
        if (openProjectTask.execute(this.getDesktopFrame(), LNG.get((String)"PRJ_WAITING_OPEN_PROJECT"), LNG.get((String)"PRJ_WAITING_OPEN_PROJECT"))) {
            CommonClientProject result = (CommonClientProject)openProjectTask.getResult();
            return result;
        }
        return null;
    }

    public Collection<ProjectBasicInfo> getRecentProjects() {
        RemoteTask<Collection<ProjectBasicInfo>> task = new RemoteTask<Collection<ProjectBasicInfo>>(){

            protected void performTask() throws Exception {
                RecentProjectsManager manager = new RecentProjectsManager();
                Collection<ProjectBasicInfo> infos = manager.getProjectsInfosFromHistory();
                for (ProjectBasicInfo info : infos) {
                    String userLogin = User.getUser((Object)info.getUserId()).getLogin();
                    info.setUserLogin(userLogin);
                }
                this.setResult(infos);
            }
        };
        String msg = LNG.get((String)"DesktopFrame.task.get.projects.history.msg");
        task.execute(this.mainFrame, this.getTitle(), msg);
        if (task.getStatus()) {
            return (Collection)task.getResult();
        }
        return null;
    }

    public AbstractAction[] getRecentProjectOpenActions() {
        Collection<ProjectBasicInfo> projectsInfos = this.getRecentProjects();
        ArrayList<OneProjectOpenAction> collection = new ArrayList<OneProjectOpenAction>();
        if (projectsInfos == null) {
            return new AbstractAction[0];
        }
        int i = 0;
        Iterator<ProjectBasicInfo> iterator = projectsInfos.iterator();
        while (iterator.hasNext() && i < 10) {
            ProjectBasicInfo projectBasicInfo = iterator.next();
            if (this.getProject() != null && this.getProject().getId().equals(projectBasicInfo.getProjectId())) continue;
            OneProjectOpenAction action = new OneProjectOpenAction(projectBasicInfo);
            collection.add(action);
            ++i;
        }
        return collection.toArray(new AbstractAction[0]);
    }

    protected JMenuItem createRestoreDesktopItem() {
        String restoreText = LNG.get((String)"DesktopFrame.menu.restore.preferences");
        JMenuItem restoreItem = new JMenuItem(restoreText);
        restoreItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DesktopFrame.this.configureDesktop();
            }
        });
        return restoreItem;
    }

    protected JMenu createLookAndFeelDesktopSubmenu() {
        JMenu lafMenu = new JMenu();
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        LookAndFeel currLaF = UIManager.getLookAndFeel();
        ButtonGroup grp = new ButtonGroup();
        for (final UIManager.LookAndFeelInfo laf : lafs) {
            AbstractAction action = new AbstractAction(laf.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DesktopFrame.this.updateLaF(laf);
                }
            };
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
            lafMenu.add(item);
            grp.add(item);
            if (!currLaF.getName().equals(laf.getName())) continue;
            item.setSelected(true);
        }
        String lafText = LNG.get((String)"DesktopFrame.submenu.laf.preferences");
        lafMenu.setText(lafText);
        return lafMenu;
    }

    private void updateLaF(UIManager.LookAndFeelInfo laf) {
        DesktopComponentFrame frame = this.getDesktopFrame();
        try {
            UIManager.setLookAndFeel(laf.getClassName());
            Container ancestor = frame.getRootPane().getTopLevelAncestor();
            SwingUtilities.updateComponentTreeUI(ancestor);
        }
        catch (Exception e) {
            String err = LNG.get((String)"DesktopFrame.laf.error.message");
            String msg = err + "\n" + e.getMessage();
            StandardDialogs.showErrorDialog((Component)frame, (String)frame.getTitle(), (String)msg);
        }
    }

    protected JMenuItem createProjectAutoUpdateItem() {
        projectAutoUpdateItem = new JCheckBoxMenuItem(LNG.get((String)"DesktopFrame.menu.project.preferences"), this.mustUpdateProjectTree());
        projectAutoUpdateItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DesktopFrame.this.autoUpdateProjectTree = projectAutoUpdateItem.isSelected();
                if (projectAutoUpdateItem.isSelected() && DesktopFrame.this.getProject() != null) {
                    RemoteTask<Void> task = new RemoteTask<Void>(){

                        protected void performTask() throws Exception {
                            DesktopFrame.this.getProject().refreshTree();
                        }
                    };
                    task.execute(DesktopFrame.this.mainFrame, DesktopFrame.this.getTitle(), LNG.get((String)"DesktopFrame.refresh.project.tree"));
                }
            }
        });
        projectAutoUpdateItem.setToolTipText(LNG.get((String)"DesktopFrame.menu.project.preferences.tooltip"));
        return projectAutoUpdateItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMenuItem createShowTreeFilterItem() {
        Class<DesktopFrame> clazz = DesktopFrame.class;
        synchronized (DesktopFrame.class) {
            showTreeFilterItem = new JCheckBoxMenuItem(new ShowTreeFilterAction(this.treeFilterPanel));
            boolean isSelected = this.getDesktopPreferences().getPreferenceAsBoolean(DesktopPref.TREE_FILTER);
            showTreeFilterItem.setSelected(isSelected);
            this.treeFilterPanel.setVisible(isSelected);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.treeFilterPanel.addListener(new TreeFilterPanelListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void visibilityChanged(boolean panelVisible) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = showTreeFilterItem;
                    synchronized (jCheckBoxMenuItem) {
                        showTreeFilterItem.setSelected(panelVisible);
                    }
                }
            });
            return showTreeFilterItem;
        }
    }

    protected JMenuItem createTrayIconItem() {
        PreferenceCategory dp = this.getDesktopPreferences();
        boolean showTrayIcon = dp.getPreferenceAsBoolean(DesktopPref.SHOW_TRAY_ICON);
        showTrayIconItem = new JCheckBoxMenuItem(LNG.get((String)"DesktopFrame.menu.trayicon.preferences"), showTrayIcon);
        showTrayIconItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SystemTray tray = SystemTray.getSystemTray();
                if (showTrayIconItem.isSelected()) {
                    try {
                        if (DesktopFrame.this.trayIcon != null) {
                            tray.add(DesktopFrame.this.trayIcon);
                        }
                    }
                    catch (AWTException e) {
                        e.printStackTrace();
                    }
                } else if (DesktopFrame.this.trayIcon != null) {
                    tray.remove(DesktopFrame.this.trayIcon);
                }
            }
        });
        showTrayIconItem.setToolTipText(LNG.get((String)"DesktopFrame.menu.trayicon.preferences.tooltip"));
        return showTrayIconItem;
    }

    protected JComponent createNotificationPanel() {
        try {
            NotificationProxy.resetObservers();
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this.getDesktopFrame(), this.getTitle(), (Throwable)e);
        }
        this.notifPanel = new BasicNotificationPanel();
        this.notifPanel.setUser(User.getLoggedUser());
        this.notifPanel.addNotificationHandler(CommandNotificationHandler.getInstance());
        this.notifPanel.addNotificationHandler(CommandPersistenceCommandNotificationHandler.getInstance());
        return this.notifPanel.getPanel();
    }

    protected JComponent createDirectoryContentsPanel() {
        this.dirContentsPanel = new DirectoryContentsPanel(this.projectTree);
        return this.dirContentsPanel;
    }

    protected JComponent createTreeFilterPanel() {
        this.treeFilterPanel = TreeFilterPanel.getInstance(this.projectTree, this.dirContentsPanel);
        this.treeFilterPanel.setVisible(false);
        return this.treeFilterPanel;
    }

    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
    }

    public boolean shouldShowHiddenFiles() {
        if (this.showHiddenFiles == null) {
            this.showHiddenFiles = this.getDesktopPreferences().getPreferenceAsBoolean(DesktopPref.SHOW_HIDDEN_FILES);
        }
        return this.showHiddenFiles;
    }

    public void setShouldExpandDataset(boolean expandDataset) {
        this.expandDataset = expandDataset;
    }

    public boolean shouldExpandDataset() {
        if (this.expandDataset == null) {
            this.expandDataset = this.getDesktopPreferences().getPreferenceAsBoolean(DesktopPref.EXPAND_DATASET);
        }
        return this.expandDataset;
    }

    public final TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public final void displayTrayInfoMessage(String message) {
        this.displayTrayMessage(message, TrayIcon.MessageType.INFO);
    }

    public final void displayTrayWarningMessage(String message) {
        this.displayTrayMessage(message, TrayIcon.MessageType.WARNING);
    }

    public final void displayTrayErrorMessage(String message) {
        this.displayTrayMessage(message, TrayIcon.MessageType.ERROR);
    }

    private void displayTrayMessage(String message, TrayIcon.MessageType type) {
        if (this.trayIcon == null) {
            return;
        }
        Client client = Client.getInstance();
        String systemName = client.getSystemName();
        this.trayIcon.displayMessage(systemName, message, type);
    }

    public CommonClientProject openProjectCreationDialog(Window window) {
        return ProjectBuildingDialog.createProject(window, null);
    }

    public CommonClientProject openProjectUpdateDialog(Window window, CommonClientProject project) {
        return ProjectBuildingDialog.updateProject(window, project, null);
    }

    public final String getClientInstanceId() {
        Client client = Client.getInstance();
        return client.getClientInstanceId();
    }

    public final String getFatherClientInstanceId() {
        Client client = Client.getInstance();
        return client.getFatherClientInstanceId();
    }

    public final void setCurrentProject(CommonClientProject prj) {
        if (this.projectTree != null) {
            this.projectTree.setProject(prj);
        }
    }
}

