/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.algorithms.executor;

import csbase.client.Client;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applications.executor.ExecutorFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.facilities.algorithms.executor.CommandObserver;
import csbase.client.facilities.algorithms.executor.CommandRemoteListener;
import csbase.client.remote.srvproxies.messageservice.MessageProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.sga.CommandRequestedListener;
import csbase.exception.OperationFailureException;
import csbase.logic.CommandInfo;
import csbase.logic.CommandNotification;
import csbase.logic.CommandSubmission;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.ClientRemoteLocator;
import csbase.util.messages.IMessageListener;
import java.awt.Window;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public abstract class AbstractCommandExecutor
implements Serializable {
    private String commandId;
    private boolean mailAtEnd = false;
    private final List<CommandRequestedListener> listeners = new LinkedList<CommandRequestedListener>();

    protected String executeCommand(AlgorithmConfigurator configurator, String description, String sgaServerName, Window owner, CommandObserver ... observers) throws RemoteException, OperationFailureException {
        return this.executeCommand(configurator, description, sgaServerName, Priority.ROOT, owner, observers);
    }

    protected String executeCommand(AlgorithmConfigurator configurator, String description, String sgaServerName, Priority priority, Window owner, CommandObserver ... observers) throws RemoteException, OperationFailureException {
        return this.executeRemoteCommand(this.makeCommandSubmission(configurator, description, sgaServerName, priority), observers);
    }

    private CommandSubmission makeCommandSubmission(AlgorithmConfigurator configurator, String description, String sgaServerName, Priority priority) {
        Object projectId = DesktopFrame.getInstance().getProject().getId();
        String clientName = Client.getInstance().getClientName();
        CommandSubmission submission = new CommandSubmission(configurator, projectId, clientName);
        submission.configureSimpleExecution(sgaServerName);
        submission.setMailAtEnd(this.getMailAtEnd());
        submission.setDescription(description);
        submission.setPriority(priority);
        return submission;
    }

    private String executeRemoteCommand(CommandSubmission submission, CommandObserver ... observers) throws RemoteException, OperationFailureException {
        if (ClientRemoteLocator.schedulerService != null) {
            Set commands = ClientRemoteLocator.schedulerService.submitCommand(submission);
            if (commands == null) {
                throw new OperationFailureException(LNG.get((String)"AbstractCommandExecutor.error.submit"));
            }
            String id = ((CommandInfo)commands.iterator().next()).getId();
            this.setCommandId(id);
            if (observers.length > 0) {
                MessageProxy.addListener((IMessageListener)new CommandRemoteListener(id, observers), CommandNotification.class);
            }
            this.notifyCommandRequestedListeners(commands);
            return id;
        }
        throw new OperationFailureException(LNG.get((String)"AbstractCommandExecutor.exception.no_scheduler"));
    }

    public boolean executeInterativeCommand(AlgorithmConfigurator configurator, String description, Window owner) {
        try {
            ExecutorFrame executorFrame = new ExecutorFrame("executor");
            executorFrame.enableLoadAlgorithms(false);
            executorFrame.showCommandRequestedInfo(false);
            ApplicationManager applicationManager = ApplicationManager.getInstance();
            applicationManager.runApplication(executorFrame);
            executorFrame.addCommandRequestedListener(new CommandRequestedListener(){

                @Override
                public void commandsWereRequested(Set<CommandInfo> submittedCommands) {
                    if (!submittedCommands.isEmpty()) {
                        Iterator<CommandInfo> iterator = submittedCommands.iterator();
                        AbstractCommandExecutor.this.setCommandId(iterator.next().getId());
                        AbstractCommandExecutor.this.notifyCommandRequestedListeners(submittedCommands);
                    }
                }
            });
            executorFrame.setSingleAlgorithm(configurator.getAlgorithmName(), new AlgorithmVersionId[]{configurator.getAlgorithmVersionId()});
            executorFrame.setCommandDescription(description);
            executorFrame.showConfigurator(configurator.getAlgorithmName(), configurator.getParameterValuesByName());
            return true;
        }
        catch (ApplicationException e) {
            StandardErrorDialogs.showExceptionDialog(owner, owner.getName(), e);
            return false;
        }
    }

    protected void notifyCommandRequestedListeners(Set<CommandInfo> submittedCommands) {
        for (CommandRequestedListener listener : this.listeners) {
            listener.commandsWereRequested(submittedCommands);
        }
    }

    public void addCommandRequestedListener(CommandRequestedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    public Object getCommandId() {
        return this.commandId;
    }

    protected void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public void setMailAtEnd(boolean mailAtEnd) {
        this.mailAtEnd = mailAtEnd;
    }

    public boolean getMailAtEnd() {
        return this.mailAtEnd;
    }
}

