/*
 * EventLogProxy.java
 *
 * @author Andr Luiz Clinio $Revision: 175310 $ - $Date: 2007-10-24 16:30:07
 * -0200 (Wed, 24 Oct 2007) $
 */
package csbase.client.remote.srvproxies;

import javax.swing.JFrame;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.util.StandardErrorDialogs;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.EventLogServiceInterface;

/**
 * Classe que modela um proxy para o servio de log-cliente
 * <code>EventLogService</code>, oferecendo uma thread separada de chamada e
 * exibindo mensagens de erro adequadas.
 *
 * @author Andr Luiz Clinio/Leonardo Barros
 */
public class EventLogProxy {

  /**
   * Mtodo interno de aviso de erro quando uma funo do proxy falha.
   *
   * @param msg mensagem a ser exibida.
   */
  private static void showError(final String msg) {
    final DesktopFrame mainFrame = DesktopFrame.getInstance();
    if (mainFrame == null) {
      return;
    }
    final JFrame jFrame = mainFrame.getDesktopFrame();
    if (jFrame == null) {
      return;
    }
    final String title = LNG.get("eventlog.proxy.title");
    StandardErrorDialogs.showErrorDialog(jFrame, title, msg);
  }

  /**
   * Mtodo utilittio para <i>alias</i> de informao gravada com somente uma
   * string; que repassa para o mtodo sobrecarregado montando um array de uma
   * string.
   *
   * @param queue a fila ou grupo de log.
   * @param info informao (string) a ser enviada.
   * @return um flag booleano indicativo de sucesso da gravao.
   */
  public static boolean addClientInformation(final String[] queue,
    final String info) {
    return addClientInformation(queue, new String[] { info });
  }

  /**
   * Mtodo do proxy para chamada ao servio <code>EventLogService</code> a
   * partir do cliente, que adiciona uma linha de informao na sintaxe
   * determinada pelo servio. Nos casos de erro, a exceo  capturada e
   * exibida ao usurio.
   *
   * @param queue fila de armazenamento.
   * @param info informaes a serem gravadas.
   * @return um flag booleano indicativo de sucesso da gravao.
   * @see #showError(String)
   */
  public static boolean addClientInformation(final String[] queue,
    final String[] info) {
    if (!ClientRemoteMonitor.getInstance().isAlive()) {
      return false;
    }

    final EventLogServiceInterface eventLogService =
      ClientRemoteLocator.eventLogService;

    final DesktopFrame mainFrame = DesktopFrame.getInstance();
    if ((mainFrame == null) || (eventLogService == null)) {
      showError(LNG.get("eventlog.proxy.msg.no_server"));
      return false;
    }

    final RemoteTask<Void> task = new RemoteTask<Void>() {
      @Override
      public void performTask() throws Exception {
        eventLogService.addClientInformation(queue, info);
      }
    };

    final String msg = LNG.get("eventlog.proxy.msg.sending_data");
    final String title = LNG.get("eventlog.proxy.title");
    return task.execute(mainFrame.getDesktopFrame(), title, msg);
  }

}
