/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.logadministration;

import csbase.client.applications.logadministration.LogAdministration;
import csbase.client.applications.logadministration.LogFileDialog;
import csbase.client.desktop.RemoteTask;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.LogAdministrationServiceInterface;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class SendLogFilesDialog
extends LogFileDialog {
    private JTextArea body = null;
    private JCheckBox admCheck = null;
    private JCheckBox supCheck = null;
    private String[] filePaths;
    SendEmailAction sendEmailAction = new SendEmailAction();
    CancelAction cancelAction = new CancelAction();

    public SendLogFilesDialog(LogAdministration application) {
        super(application);
        this.setTitle(this.getString("SendLogFilesDialog.title"));
        this.buildFrame();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SendLogFilesDialog.this.body.setText("");
                SendLogFilesDialog.this.admCheck.setSelected(false);
                SendLogFilesDialog.this.supCheck.setSelected(false);
            }
        });
    }

    private void buildFrame() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(300, 300);
        this.add((Component)this.buildBodyPanel(), new GBC(0, 0).both().insets(5, 5, 5, 5));
        this.add((Component)this.buildCheckPanel(), new GBC(0, 1).horizontal().insets(5, 5, 5, 5));
        this.add((Component)this.buildButtonPanel(), new GBC(0, 2).horizontal().insets(5, 5, 5, 5));
    }

    private JPanel buildBodyPanel() {
        JPanel bobyPanel = new JPanel(new GridBagLayout());
        BorderUtil.setTitledBorder((JComponent)bobyPanel, (String)this.getString("SendLogFilesDialog.email.body"));
        this.body = new JTextArea();
        JScrollPane bodyScrollPabe = new JScrollPane(this.body);
        bobyPanel.add((Component)bodyScrollPabe, new GBC(0, 0).both().insets(5, 5, 5, 5));
        return bobyPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        JButton sendEmailButon = new JButton(this.getString("SendLogFilesDialog.action.send"));
        sendEmailButon.addActionListener(this.sendEmailAction);
        JButton cancelButton = new JButton(this.getString("SendLogFilesDialog.action.cancel"));
        cancelButton.addActionListener(this.cancelAction);
        JComponent[] cmps = new JComponent[]{sendEmailButon, cancelButton};
        GUIUtils.matchPreferredSizes((JComponent[])cmps);
        buttonPanel.add((Component)sendEmailButon, new GBC(0, 0).none().insets(0, 0, 0, 0));
        buttonPanel.add((Component)cancelButton, new GBC(1, 0).none().insets(0, 0, 0, 0));
        return buttonPanel;
    }

    private JPanel buildCheckPanel() {
        JPanel checkPanel = new JPanel(new GridBagLayout());
        BorderUtil.setTitledBorder((JComponent)checkPanel, (String)this.getString("SendLogFilesDialog.checkbox.panel.title"));
        this.admCheck = new JCheckBox(this.getString("SendLogFilesDialog.checkbox.adm"));
        this.supCheck = new JCheckBox(this.getString("SendLogFilesDialog.checkbox.sup"));
        checkPanel.add((Component)this.admCheck, new GBC(0, 0).none().insets(0, 0, 0, 0));
        checkPanel.add((Component)this.supCheck, new GBC(1, 0).none().insets(0, 0, 0, 0));
        return checkPanel;
    }

    private String appendNewLine(String str) {
        return str + "\n\n";
    }

    static /* synthetic */ String[] access$502(SendLogFilesDialog x0, String[] x1) {
        x0.filePaths = x1;
        return x1;
    }

    private class SendToSupTask
    extends RemoteTask<Boolean> {
        private SendToSupTask() {
        }

        protected void performTask() throws Exception {
            LogAdministrationServiceInterface logAdministrationService = ClientRemoteLocator.logAdministrationService;
            this.setResult(logAdministrationService.sendlLogFilesToSuport(SendLogFilesDialog.this.appendNewLine(SendLogFilesDialog.this.body.getText()), SendLogFilesDialog.this.filePaths));
        }
    }

    private class SendToAdminTask
    extends RemoteTask<Boolean> {
        private SendToAdminTask() {
        }

        protected void performTask() throws Exception {
            LogAdministrationServiceInterface logAdministrationService = ClientRemoteLocator.logAdministrationService;
            this.setResult(logAdministrationService.sendlLogFilesToAdmin(SendLogFilesDialog.this.appendNewLine(SendLogFilesDialog.this.body.getText()), SendLogFilesDialog.this.filePaths));
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            SendLogFilesDialog.this.clearSelectedFiles();
            SendLogFilesDialog.this.setVisible(false);
        }
    }

    private class SendEmailAction
    implements ActionListener {
        private SendEmailAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Boolean result;
            String[] paths = new String[SendLogFilesDialog.this.filesInfo.length];
            for (int i = 0; i < SendLogFilesDialog.this.filesInfo.length; ++i) {
                paths[i] = SendLogFilesDialog.this.filesInfo[i].path;
            }
            SendLogFilesDialog.access$502(SendLogFilesDialog.this, paths);
            if (SendLogFilesDialog.this.admCheck.isSelected()) {
                SendToAdminTask task = new SendToAdminTask();
                if (!task.execute(((LogAdministration)SendLogFilesDialog.this.getApplication()).getApplicationFrame(), SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlogfilestask.message"), SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlogfilestask.title"))) {
                    ((LogAdministration)SendLogFilesDialog.this.getApplication()).showError(SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlog.error.msg"));
                }
                if (!(result = (Boolean)task.getResult()).booleanValue()) {
                    ((LogAdministration)SendLogFilesDialog.this.getApplication()).showError(SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlog.error.msg"));
                }
            }
            if (SendLogFilesDialog.this.supCheck.isSelected()) {
                SendToSupTask task = new SendToSupTask();
                if (!task.execute(((LogAdministration)SendLogFilesDialog.this.getApplication()).getApplicationFrame(), SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlogfilestask.message"), SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlogfilestask.title"))) {
                    ((LogAdministration)SendLogFilesDialog.this.getApplication()).showError(SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlog.error.msg"));
                }
                if (!(result = (Boolean)task.getResult()).booleanValue()) {
                    ((LogAdministration)SendLogFilesDialog.this.getApplication()).showError(SendLogFilesDialog.this.getString("SendLogFilesDialog.sendlog.error.msg"));
                }
            }
            SendLogFilesDialog.this.clearSelectedFiles();
            SendLogFilesDialog.this.setVisible(false);
        }
    }
}

