/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applications.serverdiagnostic.monitor.DefaultSwingRenderer;
import csbase.client.applications.serverdiagnostic.monitor.DiskUsagePanel;
import csbase.logic.diagnosticservice.DiskStatus;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DiskRenderer
extends DefaultSwingRenderer {
    @Override
    public JComponent getHeadline(Status status) {
        return super.getHeadline(status);
    }

    @Override
    public JComponent getDetails(Status status) {
        if (status.getCode() == StatusCode.INITIATING) {
            return this.createBlankPanel();
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        DiskStatus diskStatus = (DiskStatus)status;
        double freePerc = diskStatus.diskOccupation.getFreeSpacePerc();
        double usedPerc = diskStatus.diskOccupation.getUsedSpacePerc();
        double used = diskStatus.diskOccupation.getUsedSpaceMb();
        double free = diskStatus.diskOccupation.getFreeSpaceMb();
        DecimalFormat df = new DecimalFormat("0.##");
        double totalGB = (used + free) / 1024.0;
        JLabel totalLabel = new JLabel(this.getString("DiskRenderer.total.label") + " " + df.format(totalGB) + " Gb");
        totalLabel.setHorizontalAlignment(4);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 1, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 12;
        panel.add((Component)totalLabel, c);
        DiskUsagePanel diskPanel = new DiskUsagePanel(usedPerc, freePerc);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.anchor = 18;
        panel.add((Component)diskPanel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 18;
        panel.add((Component)super.getDetails(status), c);
        panel.validate();
        return panel;
    }

    private JPanel createBlankPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel("O monitor do disco est\u00e1 iniciando"));
        panel.setMinimumSize(new Dimension(250, 50));
        return panel;
    }
}

