/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.columns;

import csbase.client.applications.sgamonitor.columns.util.JobProcessorPair;
import csbase.client.applications.sgamonitor.columns.util.JobProcessorRenderer;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import java.util.Comparator;
import javax.swing.table.TableCellRenderer;

public class JobProcessorColumn
extends AbstractConfigurableColumn<SGASet> {
    public JobProcessorColumn(String id, Boolean visible, IStringProvider stringProvider, Integer align) {
        super(id, visible, stringProvider, align);
    }

    public Class<?> getColumnClass() {
        return JobProcessorPair.class;
    }

    public String getColumnName() {
        return this.getString(this.getId());
    }

    public Object getValue(SGASet obj) {
        JobProcessorPair result = new JobProcessorPair(0, 0);
        for (SGAInfo info : obj.getAllInfo()) {
            if (!info.getAlive()) continue;
            result.setJobs(result.getJobs() + info.getNumberOfJobs());
            result.setProcessors(result.getProcessors() + info.getNumProcessors());
        }
        return result;
    }

    @Override
    public Comparator<JobProcessorPair> getComparator() {
        return new Comparator<JobProcessorPair>(){

            @Override
            public int compare(JobProcessorPair o1, JobProcessorPair o2) {
                return o1.compareTo(o2);
            }
        };
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new JobProcessorRenderer();
    }
}

