/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.ClientSmartFile;
import csbase.client.ClientSmartFileFactory;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.AppendDescriptionDialog;
import csbase.client.project.ClientProjectFileProperties;
import csbase.client.util.ClientUtilities;
import csbase.logic.ClientOptimizationMode;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectFileFilter;
import csbase.logic.ProjectFileType;
import csbase.logic.User;
import csbase.logic.Utilities;
import csbase.logic.filters.ProjectFileTrueFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.FormatUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class FilePropertiesDialog {
    private DesktopComponentDialog propertiesDialog = null;
    private Window owner = null;
    private JButton closeButton;
    private CommonClientProject project;
    private ClientProjectFile file;
    private JTextArea descriptionArea;
    private JLabel optStatusLabel;
    private String fileName;
    private long fileSize;
    private Object fileOwner;
    private long fileCreationDate;
    private long fileLastUpdateDate;
    private ClientOptimizationMode fileOptimizationMode;
    private String fileOptimizationPath;

    public static void show(Window owner, CommonClientProject project, ClientProjectFile file) {
        new FilePropertiesDialog(owner, project, file);
    }

    private DesktopComponentDialog makeDialog() {
        DesktopComponentDialog dialog = new DesktopComponentDialog(this.owner, this.getTitle());
        dialog.setModal(false);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.add((Component)this.makePropertiesPanel(dialog.getBackground()), new GBC(0, 0).fillxy().weights(1.0, 1.0).both());
        mainPanel.add((Component)this.makeButtonPanel(), new GBC(0, 1).horizontal());
        dialog.getContentPane().setLayout(new GridBagLayout());
        dialog.getContentPane().add((Component)mainPanel, new GBC(0, 0).both());
        dialog.pack();
        dialog.center(this.owner);
        dialog.getRootPane().setDefaultButton(this.closeButton);
        return dialog;
    }

    private JPanel makePropertiesPanel(final Color background) {
        String userName;
        ImageIcon icon = ClientProjectFileProperties.getImageIcon(this.file);
        String accessMode = ClientProjectFileProperties.getAccessMode(this.file);
        ProjectFileType type = ProjectFileType.getFileType((String)this.file.getType());
        JTextField nameTextField = new JTextField(this.fileName);
        nameTextField.setEditable(false);
        String fileLocalization = this.buildLocalization();
        JTextField pathTextField = new JTextField(fileLocalization);
        pathTextField.setEditable(false);
        JLabel typeLabel = new JLabel(icon, 2);
        JTextArea typeTextArea = new JTextArea(" " + type.getDescription());
        typeTextArea.setBackground(background);
        typeTextArea.setEditable(false);
        JPanel typePanel = new JPanel(new FlowLayout(3, 0, 0));
        typePanel.add(typeLabel);
        typePanel.add(typeTextArea);
        JTextArea readOnlyTextArea = new JTextArea(accessMode);
        readOnlyTextArea.setBackground(background);
        readOnlyTextArea.setEditable(false);
        JTextArea sizeTextArea = new JTextArea(FormatUtils.formatSize((long)this.fileSize, (int)2));
        sizeTextArea.setBackground(background);
        sizeTextArea.setEditable(false);
        String creationDate = " ";
        if (this.fileCreationDate != 0L) {
            creationDate = Utilities.getFormattedDate((long)this.fileCreationDate);
        }
        JTextArea creationDateTextArea = new JTextArea(creationDate);
        creationDateTextArea.setBackground(background);
        creationDateTextArea.setEditable(false);
        String lastUpdateDate = " ";
        if (this.fileLastUpdateDate != 0L) {
            lastUpdateDate = Utilities.getFormattedDate((long)this.fileLastUpdateDate);
        }
        JTextArea lastUpdateDateTextArea = new JTextArea(lastUpdateDate);
        lastUpdateDateTextArea.setBackground(background);
        lastUpdateDateTextArea.setEditable(false);
        try {
            userName = User.getName((Object)this.fileOwner);
            if (userName == null) {
                userName = " ";
            }
        }
        catch (Exception e) {
            userName = " ";
        }
        JTextArea ownerTextArea = new JTextArea(userName);
        ownerTextArea.setBackground(background);
        ownerTextArea.setEditable(false);
        JTextField optModeTextField = new JTextField(this.getOptimizationModeText(this.fileOptimizationMode));
        optModeTextField.setBackground(background);
        optModeTextField.setEditable(false);
        optModeTextField.setBorder(null);
        final JTextField optPathTextField = new JTextField(this.fileOptimizationPath, 20);
        optPathTextField.setBackground(background);
        optPathTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent fe) {
                optPathTextField.setEditable(true);
                optPathTextField.setBackground(background);
            }

            @Override
            public void focusGained(FocusEvent fe) {
                optPathTextField.setEditable(false);
            }
        });
        optPathTextField.setCaretPosition(0);
        this.optStatusLabel = new JLabel();
        this.optStatusLabel.setPreferredSize(new Dimension(110, 25));
        JButton optStatusButton = new JButton(LNG.get((String)"PRJ_FILE_OPTIMIZATION_STATUS_BUTTON"));
        optStatusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean status = FilePropertiesDialog.this.getOptimizationStatus(FilePropertiesDialog.this.file);
                FilePropertiesDialog.this.setOptStatusTextField(status);
            }
        });
        optStatusButton.setPreferredSize(new Dimension(100, 25));
        boolean status = false;
        status = this.getOptimizationStatus(this.file);
        this.setOptStatusTextField(status);
        JPanel optStatusPanel = new JPanel(new GridBagLayout());
        optStatusPanel.add((Component)this.optStatusLabel, new GBC(0, 0).west().weightx(1.0));
        optStatusPanel.add((Component)optStatusButton, new GBC(1, 0));
        JPanel descrPanel = this.makeDescriptionPanel(background);
        JPanel panel = this.buildPropertiesLayout(nameTextField, pathTextField, typePanel, readOnlyTextArea, sizeTextArea, creationDateTextArea, lastUpdateDateTextArea, ownerTextArea, optModeTextField, optPathTextField, optStatusPanel, descrPanel);
        return panel;
    }

    private JPanel makeDescriptionPanel(Color background) {
        String description = this.getFileDescription();
        this.descriptionArea = new JTextArea(description);
        this.descriptionArea.setBackground(background);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setFont(new Font("Monospaced", 0, 12));
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        JScrollPane textScrollPane = new JScrollPane(this.descriptionArea);
        Dimension scrDim = new Dimension(400, 200);
        textScrollPane.setSize(scrDim);
        textScrollPane.setPreferredSize(scrDim);
        textScrollPane.setMinimumSize(scrDim);
        JButton descriptionButton = new JButton(LNG.get((String)"PRJ_FILE_ADD"));
        descriptionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppendDescriptionDialog appendDialog = new AppendDescriptionDialog(FilePropertiesDialog.this);
                appendDialog.setVisible(true);
            }
        });
        JPanel descrPanel = new JPanel(new GridBagLayout());
        descrPanel.add((Component)textScrollPane, new GBC(0, 0).fillxy().weightx(1.0).top(5).left(5).bottom(5).right(5).both());
        descrPanel.add((Component)descriptionButton, new GBC(0, 1).top(5).bottom(5));
        descrPanel.setBorder(BorderFactory.createTitledBorder(LNG.get((String)"PRJ_FILE_DESCRIPTION")));
        return descrPanel;
    }

    private void setOptStatusTextField(boolean status) {
        this.optStatusLabel.setForeground(status ? new Color(35, 142, 35) : Color.RED);
        this.optStatusLabel.setText(status ? LNG.get((String)"PRJ_FILE_OPTIMIZATION_STATUS_OK") : LNG.get((String)"PRJ_FILE_OPTIMIZATION_STATUS_FAILED"));
    }

    private boolean getOptimizationStatus(ClientProjectFile cpf) {
        final ClientSmartFile csf = ClientSmartFileFactory.getInstance().create(cpf);
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                this.setResult(csf.testOptimization());
            }
        };
        task.execute(this.owner, this.getTitle(), LNG.get((String)"PRJ_FILE_OPTIMIZATION_TASK_MSG"));
        if (task.getStatus()) {
            return (Boolean)task.getResult();
        }
        return false;
    }

    private String getOptimizationModeText(ClientOptimizationMode mode) {
        String key = "PRJ_FILE_OPTIMIZATION." + mode.name();
        return LNG.get((String)key);
    }

    private boolean isFileOptimized() {
        return !this.fileOptimizationMode.equals((Object)ClientOptimizationMode.NONE);
    }

    private JPanel buildPropertiesLayout(JTextField nameTextField, JTextField pathTextField, JPanel typePanel, JTextArea readOnlyTextArea, JTextArea sizeTextArea, JTextArea creationDateTextArea, JTextArea lastUpdateDateTextArea, JTextArea ownerTextArea, JTextField optModeTextField, JTextField optPathTextField, JPanel optStatusPanel, JPanel descriptionPanel) {
        JComponent[][] rowsPanel1 = new JComponent[][]{{new JLabel(LNG.get((String)"PRJ_FILE_NAME")), nameTextField}, {new JLabel(LNG.get((String)"PRJ_FILE_LOCALIZATION")), pathTextField}, {new JLabel(LNG.get((String)"PRJ_FILE_TYPE")), typePanel}, {null, readOnlyTextArea}, {new JLabel(LNG.get((String)"PRJ_FILE_SIZE")), sizeTextArea}, {new JLabel(LNG.get((String)"PRJ_FILE_CREATION_DATE")), creationDateTextArea}, {new JLabel(LNG.get((String)"PRJ_FILE_LAST_UPDATE_DATE")), lastUpdateDateTextArea}, {new JLabel(LNG.get((String)"PRJ_FILE_AUTHOR")), ownerTextArea}, {new JLabel(LNG.get((String)"PRJ_FILE_SOURCE")), null}, {new JLabel(LNG.get((String)"PRJ_FILE_OPTIMIZATION")), optModeTextField}, {this.isFileOptimized() ? new JLabel(LNG.get((String)"PRJ_FILE_OPTIMIZATION_PATH")) : null, this.isFileOptimized() ? optPathTextField : null}, {this.isFileOptimized() ? new JLabel(LNG.get((String)"PRJ_FILE_OPTIMIZATION_STATUS")) : null, this.isFileOptimized() ? optStatusPanel : null}};
        JPanel panel1 = GUIUtils.createBasicGridPanel((JComponent[][])rowsPanel1);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)panel1, new GBC(0, 0).northwest().fillx().horizontal());
        panel.add((Component)descriptionPanel, new GBC(0, 1).insets(12, 11, 12, 11).northwest().fillx().both());
        return panel;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        this.closeButton = new JButton(LNG.get((String)"UTIL_CLOSE"));
        panel.add(this.closeButton);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilePropertiesDialog.this.propertiesDialog.close();
            }
        });
        return panel;
    }

    public JDialog getDialog() {
        return this.propertiesDialog;
    }

    protected String getTitle() {
        String title = MessageFormat.format(LNG.get((String)"project.file_see_properties_title"), this.fileName);
        return ClientUtilities.addSystemNameToTitle(title);
    }

    private void retrieveFileProperties() {
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                FilePropertiesDialog.this.file.updateInfo();
                FilePropertiesDialog.this.fileName = FilePropertiesDialog.this.file.getName();
                FilePropertiesDialog.this.fileSize = FilePropertiesDialog.this.file.getTotalSize((ProjectFileFilter)ProjectFileTrueFilter.getInstance());
                FilePropertiesDialog.this.fileOwner = FilePropertiesDialog.this.file.whoCreated();
                FilePropertiesDialog.this.fileCreationDate = FilePropertiesDialog.this.file.getCreationDate();
                FilePropertiesDialog.this.fileLastUpdateDate = FilePropertiesDialog.this.file.getModificationDate();
            }
        };
        task.execute(this.owner, this.getTitle(), LNG.get((String)"PRJ_WAITING_OBTAIN_FILE_PROPERTIES"));
        ClientSmartFile smartFile = ClientSmartFileFactory.getInstance().create(this.file);
        this.fileOptimizationMode = smartFile.getOptimizationMode();
        this.fileOptimizationPath = smartFile.getLocalPath();
    }

    private String getFileDescription() {
        RemoteTask<String> task = new RemoteTask<String>(){

            protected void performTask() throws Exception {
                this.setResult(FilePropertiesDialog.this.file.getDescription());
            }
        };
        task.execute(this.owner, this.getTitle(), LNG.get((String)"PRJ_WAITING_OBTAIN_FILE_PROPERTIES"));
        if (task.getStatus()) {
            return (String)task.getResult();
        }
        return "";
    }

    private String buildLocalization() {
        String path = "[" + this.project.getName() + "]" + ": ";
        String[] filePath = this.file.getPath();
        for (int i = 1; i < filePath.length - 1; ++i) {
            path = path + filePath[i] + "/";
        }
        return path;
    }

    private FilePropertiesDialog(Window owner, CommonClientProject project, ClientProjectFile file) {
        this.owner = owner;
        this.project = project;
        this.file = file;
        this.retrieveFileProperties();
        this.propertiesDialog = this.makeDialog();
        this.propertiesDialog.setVisible(true);
        this.propertiesDialog.setDefaultCloseOperation(2);
        this.propertiesDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                FilePropertiesDialog.this.propertiesDialog.close();
            }
        });
    }

    public void updateDescription() {
        String description = this.getFileDescription();
        this.descriptionArea.setText(description);
    }

    public ClientProjectFile getFile() {
        return this.file;
    }
}

