/*
 * $Id$
 */
package csbase.client.facilities.algorithms.parameters;

import java.util.HashMap;
import java.util.Map;

import csbase.logic.algorithms.AlgorithmVersionId;

/**
 * Essa classe representa os valores dos paramtros de um n (algoritmo) do
 * fluxo, que devem ser preenchidos previamente, sem a interferncia do usurio.
 * 
 * @author pizzol
 * 
 */
public class NodeParametersValues {
  /** Nome do algoritmo que representa um n */
  private final String algorithmName;

  /** Identificador da verso do algoritmo que representa um n */
  private final AlgorithmVersionId algorithmVersionId;

  /** Mapeamento dos parmetros do n e seus valores */
  private final Map<String, String> parameterValues;

  /**
   * Obtm o nome do algoritmo.
   * 
   * @return o nome do algoritmo
   */
  public String getAlgorithmName() {
    return algorithmName;
  }

  /**
   * Obtm o identificador da verso do algoritmo.
   * 
   * @return o identificador da verso do algoritmo
   */
  public AlgorithmVersionId getAlgorithmVersionId() {
    return algorithmVersionId;
  }

  /**
   * Adiciona um valor a um determinado parmetro do algoritmo.
   * 
   * @param parameterName nome do parmetro do algoritmo
   * @param parameterValue valor do parmetro
   */
  public void addParameterValue(String parameterName, String parameterValue) {
    parameterValues.put(parameterName, parameterValue);
  }

  /**
   * Obtm todos os valores dos parmetros do algoritmo que foram preenchidos.
   * 
   * @return um mapa com todos os parmetros preenchidos e seus respectivos
   *         valores
   */
  public Map<String, String> getAllParametersValues() {
    return parameterValues;
  }

  /**
   * Construtor.
   * 
   * @param algorithmName nome do algoritmo
   * @param algorithmVersionId identificador da verso do algoritmo
   */
  public NodeParametersValues(String algorithmName,
    AlgorithmVersionId algorithmVersionId) {
    this(algorithmName, algorithmVersionId, new HashMap<String, String>());
  }

  /**
   * Construtor.
   * 
   * @param algorithmName nome do algoritmo
   * @param algorithmVersionId identificador da verso do algoritmo
   * @param parameterValues Mapa com os valores dos parmetros do algoritmo.
   */
  public NodeParametersValues(String algorithmName,
    AlgorithmVersionId algorithmVersionId, Map<String, String> parameterValues) {
    this.algorithmName = algorithmName;
    this.algorithmVersionId = algorithmVersionId;
    this.parameterValues = parameterValues;
  }

}
