package csbase.client.algorithms.commands.tasks;

import java.awt.Window;

import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandInfo;
import csbase.remote.ClientRemoteLocator;
import tecgraf.javautils.core.lng.LNG;

/**
 * Tarefa remota para obteno de um comando.
 */
public class GetCommandTask extends RemoteTask<CommandInfo> {

  /**
   * Identificador do comando.
   */
  private final String commandId;
  /**
   * Identificador do projeto.
   */
  private final Object projectId;

  /**
   * Construtor.
   *
   * @param commandId indentificador do comando.
   * @param projectId identificador do projeto.
   */
  private GetCommandTask(String commandId, Object projectId) {
    this.commandId = commandId;
    this.projectId = projectId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    CommandInfo newCommandInfo = ClientRemoteLocator.commandPersistenceService
      .getCommandInfo(projectId, commandId);
    setResult(newCommandInfo);
  }

  /**
   * Executa a tarefa de buscar o comando especificado.
   *
   * @param commandId indentificador do comando.
   * @param projectId identificador do projeto.
   * @param owner janela-me da tarefa.
   * @return o comando ou nulo caso no seja possvel obter o comando.
   */
  public static CommandInfo executeTask(String commandId, Object projectId,
    Window owner) {
    GetCommandTask task = new GetCommandTask(commandId, projectId);
    String message = LNG.get("GetCommandTask.msg");
    String title = LNG.get("GetCommandTask.title");
    if (!task.execute(owner, title, message)) {
      return null;
    }
    return task.getResult();
  }
}
