package csbase.client.algorithms.parameters;

import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.IntegerConverter;
import csbase.client.util.table.TextFieldCellView.HorizontalAlignment;
import csbase.client.util.table.TextFieldCellViewFactory;
import csbase.logic.algorithms.parameters.IntegerColumn;

/**
 * Viso para {@link IntegerColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class IntegerColumnView extends
  AbstractTableColumnView<Integer, IntegerColumn> {
  /**
   * Cria a viso.
   *
   * @param tableView A viso da tabela (No aceita {@code null}).
   * @param column A coluna (No aceita {@code null}).
   */
  public IntegerColumnView(TableParameterView tableView, IntegerColumn column) {
    super(tableView, column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CellViewFactory getFactory() {
    IntegerConverter integerConverter = new IntegerConverter();
    return new TextFieldCellViewFactory(HorizontalAlignment.RIGHT,
      integerConverter);
  }
}
