package csbase.client.algorithms.parameters;

import csbase.client.util.table.CellViewFactory;
import csbase.client.util.table.DoubleConverter;
import csbase.client.util.table.TextFieldCellView.HorizontalAlignment;
import csbase.client.util.table.TextFieldCellViewFactory;
import csbase.logic.algorithms.parameters.DoubleColumn;

/**
 * Viso para {@link DoubleColumn}.
 *
 * @author Tecgraf/PUC-Rio
 */
public final class DoubleColumnView extends
  AbstractTableColumnView<Double, DoubleColumn> {

  /**
   * Cria a viso de colunas.
   *
   * @param tableView A viso da tabela (No aceita {@code null}).
   * @param column A coluna (No aceita {@code null}).
   */
  public DoubleColumnView(TableParameterView tableView, DoubleColumn column) {
    super(tableView, column);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public CellViewFactory getFactory() {
    DoubleConverter doubleConverter = new DoubleConverter();
    return new TextFieldCellViewFactory(HorizontalAlignment.RIGHT,
      doubleConverter);
  }
}
