package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;

import javax.swing.AbstractButton;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;

/**
 * Ao de habilitar/desabilitar a exibio de rtulos nos ns do grafo.
 */
public class EnableLabelAction extends FlowApplicationAction {

  /**
   * Construtor.
   * 
   * @param application A aplicao.
   */
  public EnableLabelAction(FlowApplication application) {
    super(application, FlowApplicationUI.LABEL_ICON);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    AbstractButton aButton = (AbstractButton) e.getSource();
    boolean selected = aButton.getModel().isSelected();
    getApplication().setLabelEnabled(selected);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementCreated(Graph graph, GraphElement element) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementRemoved(Graph graph, GraphElement element) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasElementSelected(Graph graph, GraphElement element) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasChangedWorkspace(Graph graph) {
    updateEnabled(graph);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void wasReseted(Graph graph) {
    updateEnabled(graph);
  }

  /**
   * Habilita a ao, caso exista pelo menos um n no grafo. Desabilita, caso
   * contrrio.
   * 
   * @param graph O grafo.
   */
  private void updateEnabled(Graph graph) {
    if (!graph.getNodeCollection().isEmpty()) {
      setEnabled(true);
      return;
    }
    setEnabled(false);
  }

}
