package csbase.client.applications.flowapplication.util;

import java.awt.Dialog.ModalityType;

import csbase.client.desktop.RemoteTask;

/**
 * A classe <code>FlowApplicationRemoteTask</code> modela uma tarefa executada
 * no cliente que envolve chamadas a mtodos remotos.
 *
 * @param <R> A classe do resultado da tarefa.
 *
 * @author Tecgraf/PUC-Rio
 */
public abstract class FlowApplicationRemoteTask<R> extends RemoteTask<R> {

  /**
   * Construtor padro, usa como default o DOCUMENT_MODAL como poltica de
   * controle das demais telas.
   */
  public FlowApplicationRemoteTask() {
    super(ModalityType.DOCUMENT_MODAL);
  }

  /**
   * Construtor.
   *
   * @param modality poltica de controle das demais telas abertas.
   */
  public FlowApplicationRemoteTask(ModalityType modality) {
    super(modality);
  }
}
