package csbase.client.util.csvpanel.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;

import csbase.client.applications.ApplicationImages;
import csbase.client.util.csvpanel.table.CSVTable;
import csbase.client.util.csvpanel.table.CSVTableModel;

/**
 * Menu popup do cabealho de coluna da tabela, que permite a insero/remoo
 * de colunas na mesma.
 * 
 * @author Tecgraf
 */
public class ColumnHeaderPopupMenu extends CSVTablePopupMenu {

  /**
   * Item de adio de nova coluna antes da coluna selecionada.
   */
  private JMenuItem addColumnBeforeItem;
  /**
   * Item de adio de nova coluna aps a coluna selecionada.
   */
  private JMenuItem addColumnAfterItem;
  /**
   * Item de remoo da coluna selecionada.
   */
  private JMenuItem removeColumnItem;

  /**
   * Construtor.
   * 
   * @param table a tabela CSV.
   */
  public ColumnHeaderPopupMenu(final CSVTable table) {
    super(table);
    createMenu();
  }

  /**
   * Cria o contedo do menu.
   */
  private void createMenu() {
    String addColumnBeforeLabel = getString("addColumnBefore.item");
    addColumnBeforeItem =
      new JMenuItem(addColumnBeforeLabel,
        ApplicationImages.ICON_COLUMNINSERTBEFORE_16);
    addColumnBeforeItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.addColumn(popupCol);
      }
    });
    add(addColumnBeforeItem);
    String addColumnAfterLabel = getString("addColumnAfter.item");
    addColumnAfterItem =
      new JMenuItem(addColumnAfterLabel,
        ApplicationImages.ICON_COLUMNINSERTAFTER_16);
    addColumnAfterItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.addColumn(popupCol + 1);
      }
    });
    add(addColumnAfterItem);
    String removeColumnLabel = getString("removeColumn.item");
    removeColumnItem =
      new JMenuItem(removeColumnLabel, ApplicationImages.ICON_COLUMNDELETE_16);
    removeColumnItem.addActionListener(new ActionListener() {
      @Override
      public void actionPerformed(ActionEvent e) {
        CSVTableModel model = table.getModel();
        model.removeColumn(popupCol);
      }
    });
    add(removeColumnItem);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean shouldBeShown() {
    return super.shouldBeShown() && table.isEditable()
      && table.getRowCount() > 0;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void updateItemStatus() {
    removeColumnItem.setEnabled(table.getColumnCount() > 1);
  }

}
