/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmStaticInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.versiontree.PropertiesPanel;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmProperty;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public class AlgorithmBasicInfoPanel
extends CommonInfoEditPanel {
    private AlgorithmStaticInfoPanel algorithmHeaderPanel;
    private PropertiesPanel propertiesPanel;
    private JPanel mainPanel;
    private boolean isEditing;

    public AlgorithmBasicInfoPanel(CommonEditTabbedPanel algoPane) {
        super(algoPane);
    }

    private Window getWindow() {
        return ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
    }

    private JPanel getAlgoUpdatePanel() {
        JPanel updatePanel = new JPanel(new GridBagLayout());
        updatePanel.setBorder(BorderFactory.createEmptyBorder());
        List<AlgorithmProperty> algorithmProperties = AlgorithmManagementProxy.getAlgorithmProperties(this.getWindow());
        this.propertiesPanel = new PropertiesPanel(algorithmProperties, new Hashtable<String, String>(), this.getString("AlgorithmBasicInfoPanel.label.properties"), this.getWindow(), true);
        this.propertiesPanel.addPropertiesListener(wasModified -> {
            this.isEditing = wasModified;
            this.changeOperationsState(wasModified);
        });
        if (algorithmProperties.size() > 0) {
            updatePanel.add((Component)this.propertiesPanel.getPropertiesPanel(), new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
        }
        updatePanel.add((Component)this.buildEmptyPanel(), new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        return updatePanel;
    }

    @Override
    public void initializeData() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        if (!this.isEditing) {
            this.algorithmHeaderPanel.setSelectedAlgorithm(this.getSelectedAlgorithm());
            Hashtable propertyValues = new Hashtable();
            propertyValues = this.getSelectedAlgorithm().getItem().getPropertyValues();
            this.propertiesPanel.initializeFields(propertyValues);
            this.revalidate();
        }
        this.changeOperationsState(this.isEditing);
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.algorithmHeaderPanel = new AlgorithmStaticInfoPanel((AlgorithmsManager)this.getApplication());
            JPanel algoPanel = this.getAlgoUpdatePanel();
            this.mainPanel.add((Component)this.algorithmHeaderPanel, new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)algoPanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        }
        return this.mainPanel;
    }

    protected boolean saveInfo() {
        if (!this.propertiesPanel.validateProperties()) {
            return false;
        }
        this.analyzePropertyChange();
        return true;
    }

    @Override
    protected void apply() {
        this.isEditing = false;
        if (!this.saveInfo()) {
            return;
        }
    }

    @Override
    protected void cancel() {
        if (this.confirmCancelling()) {
            this.initializeData();
        }
    }

    private boolean confirmCancelling() {
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("AlgorithmBasicInfoPanel.msg.cancel.confirm"), new String[]{this.getString("AlgorithmBasicInfoPanel.msg.cancel.confirm.yes"), this.getString("AlgorithmBasicInfoPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            this.isEditing = false;
            return true;
        }
        return false;
    }

    @Override
    public void setDataChanged() {
        this.isEditing = false;
        this.changeOperationsState(this.isEditing);
    }

    private void analyzePropertyChange() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        if (this.propertiesPanel.wasModified()) {
            String name = this.getSelectedAlgorithm().getName();
            AlgorithmInfo algorithm = AlgorithmManagementProxy.changeAlgorithmProperties(name, this.propertiesPanel.getProperties(), this.getWindow());
            String dialogTitle = this.getString("AlgorithmBasicInfoPanel.label.properties");
            if (algorithm == null) {
                String title = MessageFormat.format(this.getString("AlgorithmBasicInfoPanel.title.error"), dialogTitle);
                StandardErrorDialogs.showErrorDialog(this.getWindow(), title, MessageFormat.format(this.getString("AlgorithmBasicInfoPanel.error.update"), name));
            }
        }
    }

    private AlgorithmListItem getSelectedAlgorithm() {
        return this.getAlgorithmEditDataPanel().getSelectedAlgorithm();
    }

    private AlgorithmEditDataPanel getAlgorithmEditDataPanel() {
        return (AlgorithmEditDataPanel)this.getEditPanel();
    }

    @Override
    public boolean wasModified() {
        return this.propertiesPanel.wasModified();
    }

    @Override
    protected String getTitle() {
        return ((AlgorithmsManager)this.getApplication()).getString("CommonEditTabbedPanel.tab.info.basic");
    }
}

