/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v1_0.filesystem;

import csbase.client.ClientLocalFile;
import csbase.client.csdk.v1_0.core.CSDKAbstractContext;
import csbase.client.csdk.v1_0.filesystem.CSDKFile;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.filesystem.FileSelectionType;
import csdk.v1_0.api.filesystem.IFile;
import csdk.v1_0.api.filesystem.local.ILocalFileSystemContext;
import csdk.v1_0.api.filesystem.local.LocalFileSystemException;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;

public class CSDKLocalFileSystemContext
extends CSDKAbstractContext
implements ILocalFileSystemContext {
    private ApplicationRegistry registry;

    public CSDKLocalFileSystemContext(ApplicationRegistry registry) {
        this.registry = registry;
    }

    public IFile getLocalFile(String[] path) throws LocalFileSystemException {
        String joinedPath = FileUtils.joinPath((String[])path);
        File file = new File(joinedPath);
        if (file.exists()) {
            ClientLocalFile localFile = new ClientLocalFile(file);
            return new CSDKFile(localFile);
        }
        return null;
    }

    public IFile createLocalFile(String[] path, String name, boolean isDir) throws LocalFileSystemException {
        File parent = path == null || path.length == 0 ? new File(".") : new File(FileUtils.joinPath((String[])path));
        File file = new File(parent, name);
        if (file.exists()) {
            return null;
        }
        try {
            if (isDir ? !file.mkdir() : !file.createNewFile()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new LocalFileSystemException((Throwable)e);
        }
        ClientLocalFile localFile = new ClientLocalFile(file);
        return new CSDKFile(localFile);
    }

    public IFile browseLocalFileInOpenMode(String[] fileTypes, boolean allowAll, IFile currentDir, FileSelectionType selectionType, Window frame) throws LocalFileSystemException {
        ClientLocalFile currentDirectory = null;
        if (currentDir != null) {
            String[] currentPath = currentDir.getPath();
            String joinedCurrentPath = FileUtils.joinPath((String[])currentPath);
            File localCurrentDir = new File(joinedCurrentPath);
            currentDirectory = new ClientLocalFile(localCurrentDir);
        }
        List<String> fileTypeList = fileTypes != null ? Arrays.asList(fileTypes) : Collections.emptyList();
        ClientLocalFile file = selectionType == FileSelectionType.DIRECTORIES_ONLY ? ClientLocalFileChooserUtil.browseSingleDirectoryInOpenMode(frame, fileTypeList, this.registry.getApplicationName(LNG.getLocale()), allowAll, currentDirectory) : ClientLocalFileChooserUtil.browseSingleFileInOpenMode(frame, fileTypeList, this.registry.getApplicationName(LNG.getLocale()), allowAll, currentDirectory);
        if (file == null) {
            return null;
        }
        return new CSDKFile(file);
    }

    public IFile[] browseMultipleLocalFilesInOpenMode(String[] fileTypes, boolean allowAll, IFile currentDir, FileSelectionType selectionType, Window frame) throws LocalFileSystemException {
        ClientLocalFile currentDirectory = null;
        if (currentDir != null) {
            String[] currentPath = currentDir.getPath();
            String joinedCurrentPath = FileUtils.joinPath((String[])currentPath);
            File localCurrentDir = new File(joinedCurrentPath);
            currentDirectory = new ClientLocalFile(localCurrentDir);
        }
        List<String> fileTypeList = fileTypes != null ? Arrays.asList(fileTypes) : Collections.emptyList();
        List<ClientLocalFile> files = selectionType == FileSelectionType.DIRECTORIES_ONLY ? ClientLocalFileChooserUtil.browseMultipleDirectoriesInOpenMode(frame, fileTypeList, this.registry.getApplicationName(LNG.getLocale()), allowAll, currentDirectory) : ClientLocalFileChooserUtil.browseMultipleFilesInOpenMode(frame, fileTypeList, this.registry.getApplicationName(LNG.getLocale()), allowAll, currentDirectory);
        if (files == null) {
            return null;
        }
        ArrayList<CSDKFile> selectedFiles = new ArrayList<CSDKFile>();
        for (ClientLocalFile file : files) {
            selectedFiles.add(new CSDKFile(file));
        }
        return selectedFiles.toArray(new IFile[selectedFiles.size()]);
    }

    public IFile browseLocalFileInSaveMode(String[] fileTypes, boolean allowAll, String defaultName, IFile currentDir, Window frame) throws LocalFileSystemException {
        List<String> fileTypeList;
        ClientLocalFile file;
        ClientLocalFile currentDirectory = null;
        if (currentDir != null) {
            String[] currentPath = currentDir.getPath();
            String joinedCurrentPath = FileUtils.joinPath((String[])currentPath);
            File localCurrentDir = new File(joinedCurrentPath);
            currentDirectory = new ClientLocalFile(localCurrentDir);
        }
        if ((file = ClientLocalFileChooserUtil.browseSingleFileInSaveMode(frame, fileTypeList = fileTypes != null ? Arrays.asList(fileTypes) : Collections.emptyList(), null, this.registry.getApplicationName(LNG.getLocale()), allowAll, currentDirectory)) == null) {
            return null;
        }
        return new CSDKFile(file);
    }

    public boolean removeLocalFile(String[] path) {
        String joinedPath = FileUtils.joinPath((String[])path);
        File file = new File(joinedPath);
        return file.delete();
    }
}

