/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.preferences;

import csbase.client.preferences.PreferenceValue;
import csbase.client.preferences.definition.PreferencePolicy;
import csbase.client.preferences.util.PreferenceEditorListener;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class PreferenceEditor<T> {
    private PreferenceValue<T> pv;
    private T value;
    protected static Font font = new Font("SansSerif", 0, 13);
    private List<PreferenceEditorListener> listeners;

    public PreferenceEditor(PreferenceValue<T> pv) {
        if (pv == null) {
            throw new IllegalArgumentException("value n\u00e3o pode ser nulo.");
        }
        this.pv = pv;
        this.listeners = new ArrayList<PreferenceEditorListener>();
    }

    public String getLabel() {
        return this.pv.getLabel();
    }

    public void setValue(T newValue) {
        this.value = newValue;
    }

    public T getValue() {
        return this.value;
    }

    public void commit() {
        this.pv.setValue(this.value);
    }

    public JComponent getComponent(boolean showDefaultValue) {
        if (showDefaultValue) {
            this.setValue(this.pv.getDefaultValue());
        } else {
            Object v = this.pv.clone();
            this.setValue(((PreferenceValue)v).getValue());
        }
        return this.createComponent();
    }

    public boolean isEditable() {
        return PreferencePolicy.READ_WRITE.equals((Object)this.pv.getPolicy());
    }

    public void addListener(PreferenceEditorListener l) {
        this.listeners.add(l);
    }

    public boolean hasListeners() {
        return !this.listeners.isEmpty();
    }

    public void removeListener(PreferenceEditorListener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners() {
        for (PreferenceEditorListener l : this.listeners) {
            l.action();
        }
    }

    protected void setTitledBorder(JPanel panel) {
        this.setTitledBorder(panel, this.pv.getLabel());
    }

    protected void setTitledBorder(JPanel panel, String title) {
        panel.setBorder(BorderFactory.createTitledBorder(null, title, 4, 0, font, null));
    }

    protected String getString(String tag) {
        return this.pv.getPreferenceBundle().get(tag);
    }

    protected boolean hasString(String tag) {
        return this.pv.getPreferenceBundle().has(tag);
    }

    protected String getPrefixedString(String tag) {
        return this.getString(this.getClass().getSimpleName() + "." + tag);
    }

    protected abstract JComponent createComponent();
}

