/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.validation;

import csbase.client.algorithms.validation.ValidationTranslator;
import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.validation.Validation;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class ValidationResultPanel
extends JPanel {
    public ValidationResultPanel(Validation validation, int n) {
        List<ValidationTranslator.StatusMessage> messages = ValidationTranslator.recursiveTranslateMessage(validation, null);
        if (messages == null || messages.size() <= 0) {
            return;
        }
        this.setLayout(new GridBagLayout());
        if (messages.size() <= n) {
            List<JLabel> labels = this.recursiveBuildLabels(validation, null);
            int y = 0;
            for (JLabel label : labels) {
                this.add((Component)label, new GBC(0, y).horizontal().west().insets(0, 0, 0, 0));
                ++y;
            }
            return;
        }
        int y = 0;
        JLabel firstRow = new JLabel(LNG.get((String)"ValidationResultPanel.n.result.message", (Object[])new Object[]{messages.size()}));
        if (validation.isWellSucceeded()) {
            firstRow.setIcon(ApplicationImages.ICON_WARNING_16);
        } else {
            firstRow.setIcon(ApplicationImages.ICON_ERROR_16);
        }
        this.add((Component)firstRow, new GBC(0, y).horizontal().west().insets(0, 0, 0, 0));
        ++y;
        for (int i = 0; i < n; ++i) {
            JLabel label = new JLabel("<html>&#x25AA;&nbsp;&nbsp;" + messages.get((int)i).message);
            this.add((Component)label, new GBC(0, y).horizontal().west().insets(2, 18, 0, 0));
            ++y;
        }
        JLabel lastRow = new JLabel("+ " + (messages.size() - n));
        this.add((Component)lastRow, new GBC(0, y).horizontal().west().insets(2, 18, 0, 0));
    }

    public ValidationResultPanel(Validation validation) {
        List<JLabel> labels = this.recursiveBuildLabels(validation, null);
        this.setLayout(new GridBagLayout());
        JLabel introduction = new JLabel(LNG.get((String)"ValidationResultPanel.full.result.message"));
        this.add((Component)introduction, new GBC(0, 0).horizontal().west().insets(2, 0, 12, 0));
        int y = 1;
        for (JLabel label : labels) {
            this.add((Component)label, new GBC(0, y).horizontal().west().insets(4, 0, 0, 0));
            ++y;
        }
        this.add((Component)new JLabel(), new GBC(0, y).horizontal().west().insets(12, 0, 0, 0));
    }

    private List<JLabel> recursiveBuildLabels(Validation validation, String prefix) {
        ArrayList<JLabel> labels = new ArrayList<JLabel>();
        List<ValidationTranslator.StatusMessage> messages = ValidationTranslator.recursiveTranslateMessage(validation, null);
        for (ValidationTranslator.StatusMessage message : messages) {
            JLabel label = new JLabel(message.message);
            if (message.status) {
                label.setIcon(ApplicationImages.ICON_WARNING_16);
            } else {
                label.setIcon(ApplicationImages.ICON_ERROR_16);
            }
            labels.add(label);
        }
        return labels;
    }
}

