/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.application.manager;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.manager.IApplicationManagerContext;
import tecgraf.javautils.core.lng.LNG;

public class CSDKApplicationManagerContext
extends CSDKAbstractContext
implements IApplicationManagerContext {
    private final String instanceId;

    public CSDKApplicationManagerContext(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean isApplicationRunning(String instanceId) {
        ApplicationManager manager = ApplicationManager.getInstance();
        return manager.getApplicationInstance(instanceId) != null;
    }

    public void killApplication(String instanceId) throws ApplicationException {
        ApplicationManager manager = ApplicationManager.getInstance();
        ApplicationType senderApp = manager.getApplicationInstance(instanceId);
        if (senderApp != null && !senderApp.closeApplication()) {
            String errorMsg = LNG.get((String)(CSDKApplicationManagerContext.class.getSimpleName() + ".kill.error"));
            throw new ApplicationException(errorMsg);
        }
    }

    public void sendAsyncMessage(String appInstanceId, IMessage message) throws ApplicationException {
        ApplicationManager manager = ApplicationManager.getInstance();
        manager.sendAsyncMessage(appInstanceId, message.getType(), message.getValue(), this.instanceId);
    }

    public void broadcastAsyncMessage(IMessage message) throws ApplicationException {
        ApplicationManager manager = ApplicationManager.getInstance();
        manager.broadcastAsyncMessage(message.getType(), message.getValue(), this.instanceId);
    }

    public Object sendSyncMessage(String appInstanceId, IMessage message) throws ApplicationException {
        ApplicationManager manager = ApplicationManager.getInstance();
        return manager.sendSyncMessage(appInstanceId, message.getType(), message.getValue(), this.instanceId);
    }

    public String runApplication(String id) throws ApplicationException {
        ApplicationManager manager = ApplicationManager.getInstance();
        try {
            if (!manager.hasApplicationRegistry(id)) {
                return null;
            }
            Object app = manager.runApplication(id);
            if (app == null) {
                return null;
            }
            return ((ApplicationType)app).getInstanceId();
        }
        catch (csbase.client.applicationmanager.ApplicationException e) {
            throw new ApplicationException((Throwable)e);
        }
    }
}

