/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.csdk.v2.filesystem;

import csbase.client.ClientLocalFile;
import csbase.client.ClientSmartFile;
import csbase.client.csdk.v2.filesystem.CSDKLocalFileLock;
import csbase.client.csdk.v2.filesystem.CSDKProjectFileLock;
import csbase.client.project.ClientFileLock;
import csbase.logic.ClientFile;
import csbase.logic.ClientFileType;
import csbase.logic.ClientProjectFile;
import csdk.v2.api.filesystem.FileLocationType;
import csdk.v2.api.filesystem.FileLockedException;
import csdk.v2.api.filesystem.IFile;
import csdk.v2.api.filesystem.IFileLock;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import tecgraf.javautils.core.io.FileUtils;

public class CSDKFile
implements IFile {
    private final ClientFile file;

    public CSDKFile(ClientFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Par\u00e2metro file n\u00e3o pode ser nulo");
        }
        this.file = file;
    }

    public void close(boolean force) throws IOException {
        this.file.close(force);
    }

    public void close() throws IOException {
        this.file.close(true);
    }

    public IFile[] getChildren() throws Exception {
        ClientFile[] children = this.file.getChildren();
        ArrayList<CSDKFile> files = new ArrayList<CSDKFile>();
        for (ClientFile clientProjectFile : children) {
            files.add(new CSDKFile(clientProjectFile));
        }
        return files.toArray(new IFile[files.size()]);
    }

    public InputStream getInputStream() throws IOException {
        return this.file.getInputStream();
    }

    public long getModificationDate() {
        return this.file.getModificationDate();
    }

    public String getName() {
        return this.file.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.file.getOutputStream();
    }

    public String[] getPath() {
        return this.file.getPath();
    }

    public String getStringPath() {
        return this.file.getStringPath();
    }

    public String getType() {
        return this.file.getType();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public void open(boolean readOnly) throws Exception {
        this.file.open(readOnly);
    }

    public long position() throws IOException {
        return this.file.position();
    }

    public void position(long newPosition) throws IOException {
        this.file.position(newPosition);
    }

    public int read(byte[] dst, int off, int len, long position) throws Exception {
        return this.file.read(dst, off, len, position);
    }

    public int read(byte[] dst, long position) throws Exception {
        return this.file.read(dst, position);
    }

    public long size() {
        return this.file.size();
    }

    public void write(byte[] src, int off, int len, long position) throws IOException, FileLockedException {
        this.file.write(src, off, len, position);
    }

    public void write(byte[] src, long position) throws IOException, FileLockedException {
        this.file.write(src, position);
    }

    public FileLocationType getFileLocationType() {
        switch (this.file.getClientFileType()) {
            case LOCAL: {
                return FileLocationType.LOCAL;
            }
            case REMOTE: {
                return FileLocationType.REMOTE;
            }
            case SMART: {
                return FileLocationType.REMOTE;
            }
        }
        return null;
    }

    public ClientFile getFile() {
        return this.file;
    }

    public IFile getParent() {
        ClientFile parent = this.file.getParent();
        if (parent == null) {
            return null;
        }
        return new CSDKFile(parent);
    }

    public boolean exists() throws IOException {
        return this.file.exists();
    }

    public boolean canExecute() {
        return this.file.canExecute();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public IFileLock acquireExclusiveLock(Window window) throws Exception {
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            return new CSDKProjectFileLock(ClientFileLock.acquireExclusiveLock(window, projectFile));
        }
        if (this.file.getClientFileType() == ClientFileType.SMART) {
            ClientSmartFile smartFile = (ClientSmartFile)this.file;
            return new CSDKProjectFileLock(ClientFileLock.acquireExclusiveLock(window, smartFile.getClientProjectFile()));
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        String[] path = clientlocalFile.getPath();
        File localFile = new File(FileUtils.joinPath((String[])path));
        return new CSDKLocalFileLock(localFile, false, window);
    }

    public IFileLock acquireSharedLock(Window window) throws Exception {
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            return new CSDKProjectFileLock(ClientFileLock.acquireSharedLock(window, projectFile));
        }
        if (this.file.getClientFileType() == ClientFileType.SMART) {
            ClientSmartFile smartFile = (ClientSmartFile)this.file;
            return new CSDKProjectFileLock(ClientFileLock.acquireSharedLock(window, smartFile.getClientProjectFile()));
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        String[] path = clientlocalFile.getPath();
        File localFile = new File(FileUtils.joinPath((String[])path));
        return new CSDKLocalFileLock(localFile, true, window);
    }

    public IFile getChild(String name, Window window) throws Exception {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Par\u00e2metro name n\u00e3o pode ser nulo");
        }
        if (!this.isDirectory()) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel listar filhos: caminho n\u00e3o corresponde a diret\u00f3rio.");
        }
        ClientFile[] files = this.file.getChildren();
        if (files == null) {
            return null;
        }
        for (ClientFile clientFile : files) {
            if (!clientFile.getName().equals(name)) continue;
            return new CSDKFile(clientFile);
        }
        return null;
    }

    public boolean isHidden() {
        return this.file.getName().charAt(0) == '.';
    }

    public boolean rename(String newName, Window window) throws Exception {
        if (newName == null) {
            throw new IllegalArgumentException("Par\u00e2metro newName n\u00e3o pode ser nulo");
        }
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            projectFile.rename(newName);
            return true;
        }
        if (this.file.getClientFileType() == ClientFileType.SMART) {
            ClientSmartFile smartFile = (ClientSmartFile)this.file;
            smartFile.getClientProjectFile().rename(newName);
            return true;
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        return clientlocalFile.rename(newName);
    }

    public boolean move(IFile newParent, Window window) throws Exception {
        if (newParent == null) {
            throw new IllegalArgumentException("Par\u00e2metro newParent n\u00e3o pode ser nulo");
        }
        CSDKFile parentDir = (CSDKFile)newParent;
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            if (newParent.getFileLocationType() == FileLocationType.REMOTE && newParent.isDirectory()) {
                ClientProjectFile parentDirFile = (ClientProjectFile)parentDir.getFile();
                projectFile.move(parentDirFile);
                return true;
            }
        } else if (this.file.getClientFileType() == ClientFileType.SMART) {
            ClientSmartFile smartFile = (ClientSmartFile)this.file;
            if (newParent.getFileLocationType() == FileLocationType.REMOTE && newParent.isDirectory()) {
                ClientProjectFile parentDirFile = (ClientProjectFile)parentDir.getFile();
                smartFile.getClientProjectFile().move(parentDirFile);
                return true;
            }
        } else {
            ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
            if (newParent.getFileLocationType() == FileLocationType.LOCAL && newParent.isDirectory()) {
                ClientLocalFile parentDirFile = (ClientLocalFile)parentDir.getFile();
                return clientlocalFile.move(parentDirFile);
            }
        }
        return false;
    }

    public boolean delete(Window window) throws Exception {
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            projectFile.remove();
            return true;
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        return clientlocalFile.remove();
    }

    public IFile copy(IFile newParent, Window window) throws Exception {
        if (newParent == null) {
            throw new IllegalArgumentException("Par\u00e2metro newParent n\u00e3o pode ser nulo");
        }
        CSDKFile parentDir = (CSDKFile)newParent;
        if (this.isDirectory()) {
            throw new Exception("Diret\u00f3rio n\u00e3o pode ser copiado!");
        }
        if (this.file.getClientFileType() == ClientFileType.REMOTE) {
            ClientProjectFile projectFile = (ClientProjectFile)this.file;
            return this.copyRemote(projectFile, parentDir, window);
        }
        if (this.file.getClientFileType() == ClientFileType.SMART) {
            ClientSmartFile smartFile = (ClientSmartFile)this.file;
            return this.copyRemote(smartFile.getClientProjectFile(), parentDir, window);
        }
        if (!newParent.isDirectory()) {
            throw new Exception("Destino n\u00e3o \u00e9 um diret\u00f3rio: " + newParent.getStringPath());
        }
        ClientLocalFile clientlocalFile = (ClientLocalFile)this.file;
        if (newParent.getFileLocationType() == FileLocationType.LOCAL) {
            ClientLocalFile parentDirFile = (ClientLocalFile)parentDir.getFile();
            ClientLocalFile copy = clientlocalFile.copy(parentDirFile);
            if (copy != null) {
                return new CSDKFile(copy);
            }
            return null;
        }
        return null;
    }

    private IFile copyRemote(ClientProjectFile projectFile, CSDKFile parentDir, Window window) throws Exception {
        if (parentDir.getFileLocationType() == FileLocationType.REMOTE && parentDir.isDirectory()) {
            ClientProjectFile parentDirFile = (ClientProjectFile)parentDir.getFile();
            projectFile.copy(parentDirFile);
            return parentDir.getChild(this.getName(), window);
        }
        return null;
    }
}

