/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.instancestoolbar;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationManagerListener;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.desktop.instancestoolbar.ApplicationInstancesToolbarMouseAdapter;
import csbase.logic.applicationservice.ApplicationRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class ApplicationInstancesToolbar
extends JPanel
implements ApplicationManagerListener {
    private static final int IMG_SIZE = 16;
    private static final Color NULL_COLOR = new JLabel().getBackground();
    private final JPanel appPanel = new JPanel();

    protected static void setWidgetBorder(JComponent component, boolean highlight) {
        Color color = highlight ? Color.gray : NULL_COLOR;
        boolean brdy_o = false;
        int brdy_i = 5;
        boolean brd = false;
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), BorderFactory.createEmptyBorder(5, 0, 5, 0)));
        component.setBorder(border);
    }

    @Override
    public void applicationEnded(String id) {
        this.updateWidgets();
    }

    @Override
    public void applicationStarted(String id) {
        this.updateWidgets();
    }

    private void updateWidgets() {
        this.appPanel.removeAll();
        GridBagLayout layout = new GridBagLayout();
        this.appPanel.setLayout(layout);
        ApplicationManager mng = ApplicationManager.getInstance();
        Hashtable<String, Vector<ApplicationType>> apps = mng.getRunningApplications();
        Enumeration<String> keys = apps.keys();
        int numWidgets = 0;
        Enumeration<String> e = keys;
        while (e.hasMoreElements()) {
            String id = e.nextElement();
            ApplicationRegistry reg = mng.getApplicationRegistry(id);
            Vector<ApplicationType> instances = apps.get(id);
            int numInstances = instances.size();
            if (numInstances <= 0) continue;
            JComponent widget = this.createWidget(reg, instances);
            this.appPanel.add((Component)widget, new GBC(numWidgets, 0).center());
            ++numWidgets;
        }
        this.appPanel.add((Component)new JPanel(), new GBC(numWidgets, 0).center().horizontal());
        JComponent[] components = new JComponent[numWidgets];
        for (int i = 0; i < numWidgets; ++i) {
            components[i] = (JComponent)this.appPanel.getComponent(i);
        }
        GUIUtils.matchPreferredSizes((JComponent[])components);
        this.appPanel.validate();
        this.appPanel.repaint();
    }

    private JComponent createWidget(ApplicationRegistry reg, Vector<ApplicationType> instances) {
        JLabel widget = new JLabel();
        widget.setText(" (" + instances.size() + ")");
        widget.setFont(widget.getFont().deriveFont(0));
        ApplicationManager appManager = ApplicationManager.getInstance();
        widget.setToolTipText(appManager.getApplicationName(reg));
        ImageIcon icon = null;
        byte[] iconDefinition = reg.getIconDefinition();
        if (iconDefinition != null) {
            icon = new ImageIcon(iconDefinition);
        }
        widget.setIcon(icon);
        widget.setOpaque(true);
        widget.setHorizontalAlignment(0);
        widget.setVerticalAlignment(0);
        int h = (int)Math.round(17.6);
        Dimension dim = new Dimension(75, h);
        widget.setMinimumSize(dim);
        widget.setPreferredSize(dim);
        widget.setSize(dim);
        ApplicationInstancesToolbarMouseAdapter adp = new ApplicationInstancesToolbarMouseAdapter(widget, instances);
        widget.addMouseListener(adp);
        ApplicationInstancesToolbar.setWidgetBorder(widget, false);
        return widget;
    }

    public ApplicationInstancesToolbar() {
        ApplicationManager mng = ApplicationManager.getInstance();
        mng.addListener(this);
        int h = (int)Math.round(25.6);
        Dimension dim = new Dimension(30, h);
        this.appPanel.setMinimumSize(dim);
        this.appPanel.setSize(dim);
        this.appPanel.setPreferredSize(dim);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.appPanel, new GBC(1, 0).center().horizontal());
    }
}

