/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.logic.ClientProjectFile;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class CommonFileChangeStateAction
extends CommonProjectAction {
    public CommonFileChangeStateAction(ProjectFileContainer container) {
        super(container);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final ClientProjectFile file = this.getSelectedFile();
        String fileName = file.getName();
        String title = LNG.get((String)"CommonFileChangeStateAction.title");
        String text = String.format(LNG.get((String)"CommonFileChangeStateAction.confirmation"), fileName);
        int option = StandardDialogs.showOptionDialog((Component)this.getWindow(), (String)title, (Object)text, (Object[])new String[]{LNG.get((String)"CommonFileChangeStateAction.button.change"), LNG.get((String)"CommonFileChangeStateAction.button.cancel")});
        if (option != 0) {
            return;
        }
        RemoteTask<Boolean> task = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                ClientRemoteLocator.projectService.setUnderConstruction(file.getProjectId(), file.getPath(), false);
            }
        };
        boolean result = task.execute(this.getWindow(), title, String.format(LNG.get((String)"CommonFileChangeStateAction.info.changind.state"), fileName));
        if (result) {
            this.showError(title, String.format(LNG.get((String)"CommonFileChangeStateAction.error.changind.state"), fileName));
        }
    }

    @Override
    public String getName() {
        return LNG.get((String)"CommonFileChangeStateAction.name");
    }
}

