/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies.messageservice.consumers;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.messageservice.consumers.IMessageConsumer;
import csbase.client.remote.srvproxies.messageservice.consumers.MessagePollingConsumer;
import csbase.client.util.CodeBlockLog;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ServerURI;
import csbase.remote.ClientRemoteLocator;
import csbase.util.messages.Message;
import csbase.util.rmi.PortReference;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tecgraf.javautils.core.filter.IFilter;
import tecgraf.javautils.core.lng.LNG;

public class AdaptableMessageConsumer
implements IMessageConsumer {
    private static Logger LOGGER = Logger.getLogger(AdaptableMessageConsumer.class.getName());
    private IMessageConsumer consumer;
    private boolean loggedIn = true;
    private IMessageConsumer.IListener listener;
    private IFilter<Message> filter;
    private PortReference portRef = new PortReference();

    public AdaptableMessageConsumer() {
        if (this.listener != null && this.getConsumer() != null) {
            this.getConsumer().setListener(this.listener, this.filter);
        }
        ClientServerManager.getInstance().addListener(new MonitoredServerListener(){

            public void notifyLoggedOut(ServerURI serverURI) {
                this.setLoggedOut();
            }

            public void notifyLoggedIn(ServerURI serverURI) {
                this.setLoggedIn();
            }

            public void notifyConnectionReestablished(ServerURI serverURI) {
                this.setLoggedIn();
            }

            public void notifyConnectionLost(ServerURI serverURI) {
                this.setLoggedOut();
            }

            private void setLoggedOut() {
                AdaptableMessageConsumer.this.loggedIn = false;
                AdaptableMessageConsumer.this.destroyConsumer();
            }

            private void setLoggedIn() {
                AdaptableMessageConsumer.this.loggedIn = true;
                if (AdaptableMessageConsumer.this.listener != null && AdaptableMessageConsumer.this.getConsumer() != null) {
                    AdaptableMessageConsumer.this.getConsumer().setListener(AdaptableMessageConsumer.this.listener, (IFilter<Message>)AdaptableMessageConsumer.this.filter);
                }
            }
        });
    }

    @Override
    public void setListener(IMessageConsumer.IListener listener, IFilter<Message> filter) {
        this.listener = listener;
        this.filter = filter;
        if (this.getConsumer() != null) {
            CodeBlockLog log = new CodeBlockLog(Level.FINER, "Alterando o ouvinte de mensagens", new Object[0]);
            LOGGER.log(log.begin());
            this.getConsumer().setListener(listener, filter);
            LOGGER.log(log.finished());
        }
    }

    @Override
    public void clearListener() {
        this.listener = null;
        this.filter = null;
        if (this.getConsumer() != null) {
            CodeBlockLog log = new CodeBlockLog(Level.FINER, "Desligando o ouvinte de mensagens", new Object[0]);
            LOGGER.log(log.begin());
            this.getConsumer().clearListener();
            LOGGER.log(log.finished());
        }
    }

    private IMessageConsumer getConsumer() {
        if (!this.loggedIn) {
            return null;
        }
        if (this.consumer == null) {
            CodeBlockLog log = new CodeBlockLog(Level.FINER, "Criando o consumidor de mensagens", new Object[0]);
            LOGGER.log(log.begin());
            RemoteTask<IMessageConsumer> task = new RemoteTask<IMessageConsumer>(){

                protected void performTask() throws Exception {
                    this.setResult(AdaptableMessageConsumer.this.createMessageConsumerStrategy());
                }
            };
            DesktopComponentFrame window = null;
            DesktopFrame mainFrame = DesktopFrame.getInstance();
            if (mainFrame != null) {
                window = mainFrame.getDesktopFrame();
            }
            if (task.execute(window, LNG.get((String)"MESSAGE_PROXY_TITLE"), LNG.get((String)"MESSAGE_PROXY_CREATING_CONSUMER"))) {
                this.consumer = (IMessageConsumer)task.getResult();
            }
            LOGGER.log(log.finished());
        }
        return this.consumer;
    }

    private void destroyConsumer() {
        this.consumer = null;
    }

    private IMessageConsumer createMessageConsumerStrategy() throws RemoteException {
        return new MessagePollingConsumer(ClientRemoteLocator.messageService, 5L, TimeUnit.SECONDS);
    }
}

