/*
 * $Id: ParameterLoaderCommandListener.java 85068 2008-10-31 20:19:56Z isabella
 * $
 */

package csbase.client.algorithms.parameters;

import csbase.client.desktop.CommandListener;
import csbase.logic.CommandEndNotification;
import csbase.logic.CommandNotification;
import csbase.logic.CommandSuccessNotification;

/**
 * Esta classe monitora as notificaes sobre a execuo dos comandos do
 * carregador de parmetros.
 */
public class ParameterLoaderCommandListener implements CommandListener {
  /** Identificador do comando */
  private Object commandId;
  /** A task de execuo do comando */
  private ParameterLoaderCommandExecutionTask task;
  /** Indica se o listener deve ser removido aps receber a notificao. */
  private boolean remove;

  /**
   * Constri um <code>ParameterLoaderCommandListener</code>.
   * 
   * @param task a tarefa que vai submeter o comando do carregamento.
   * @param commandId o identificador do comando do carregamento que se deseja
   *        observar.
   */
  protected ParameterLoaderCommandListener(
    ParameterLoaderCommandExecutionTask task, Object commandId) {
    this.commandId = commandId;
    this.task = task;
    this.remove = false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void notifyCommand(CommandNotification data) {
    if (!isInterested(data)) {
      return;
    }
    task.executionCompleted(data instanceof CommandEndNotification
      || data instanceof CommandSuccessNotification);
    remove = true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean shouldRemove() {
    return remove;
  }

  /**
   * Determina se a notificao indica  de interesse do observador.
   * 
   * @param data a notificao.
   * @return verdadeiro se a notificao  de interesse ou falso, caso
   *         contrrio.
   */
  private boolean isInterested(CommandNotification data) {
    return commandId.equals(data.getCommandId());
  }
}
