package csbase.client.csdk.v1_0.core;

import csdk.v1_0.api.core.IContext;

/**
 * Classe base para implementao de contextos CSDK.
 */
public class CSDKAbstractContext implements IContext {

  /**
   * Indica se o contexto est ativo.
   */
  private boolean active;

  /**
   * Construtor padro.
   */
  public CSDKAbstractContext() {
    this.active = false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void onContextActivate() {
    try {
      contextActivated();
    }
    finally {
      this.active = true;
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean isActive() {
    return this.active;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void onContextDeactivate() {
    try {
      contextDeactivated();
    }
    finally {
      this.active = false;
    }
  }

  /**
   * Inicializa o contexto.
   */
  protected void contextActivated() {
    // Por padro, no faz nada
  }

  /**
   * Finaliza o contexto.
   */
  protected void contextDeactivated() {
    // Por padro, no faz nada
  }

}
