/*
 * $Id: DesktopComponentDialog.java 125402 2012-01-03 12:01:12Z caduandr $
 */

package csbase.client.desktop;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.WindowConstants;

import tecgraf.javautils.gui.GUIUtils;

/**
 * Dilogo de componente de desktop.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DesktopComponentDialog extends JDialog implements
  DesktopWindowInterface {

  /**
   * Construo da janela
   */
  private void build() {
    setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
    DesktopFrame desktopFrame = DesktopFrame.getInstance();
    if (desktopFrame != null) {
      desktopFrame.addWindow(this);
    }
  }

  /**
   * Centralizao
   */
  public void center() {
    this.center(getOwner());
  }

  /**
   * Centralizao
   * 
   * @param window a janela de referncia para centralizao
   */
  public void center(Window window) {
    if (window == null) {
      GUIUtils.centerOnScreen(this);
      return;
    }

    if (window instanceof JFrame) {
      // getSize(), getX() e getY() no levam em considerao o fato da janela
      // de referncia estar maximizada; neste caso, centralizamos na tela.
      JFrame jframe = (JFrame) window;
      final int windowState = jframe.getExtendedState();
      if ((windowState & Frame.MAXIMIZED_BOTH) != 0) {
        GUIUtils.centerOnScreen(this);
        return;
      }
    }
    Dimension currentSize = this.getSize();
    Dimension windowSize = window.getSize();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    int minX = window.getX() + (windowSize.width - currentSize.width) / 2;
    if ((minX + currentSize.width) > screenSize.width) {
      minX = screenSize.width - currentSize.width;
    }
    if (minX < 0) {
      minX = 0;
    }
    int minY = window.getY() + (windowSize.height - currentSize.height) / 2;
    if ((minY + currentSize.height) > screenSize.height) {
      minY = screenSize.height - currentSize.height;
    }
    if (minY < 0) {
      minY = 0;
    }
    this.setLocation(minX, minY);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void close() {
    DesktopFrame desktopFrame = DesktopFrame.getInstance();
    if (desktopFrame != null) {
      desktopFrame.removeWindow(this);
    }
    dispose();
  }

  /**
   * Construtor
   * 
   * @param owner frame pai. Caso seja <code>NULL</code>, o owner ser a
   *        interface principal do sistema ou nenhum se no existir
   *        {@link DesktopFrame} instanciado.
   */
  public DesktopComponentDialog(Window owner) {
    this(owner, null);
  }

  /**
   * Construtor
   * 
   * @param owner frame pai. Caso seja <code>NULL</code>, o owner ser a
   *        interface principal do sistema ou nenhum se no existir
   *        {@link DesktopFrame} instanciado.
   * @param title ttulo
   */
  public DesktopComponentDialog(Window owner, String title) {
    super(owner == null ? (DesktopFrame.getInstance() == null ? null
      : DesktopFrame.getInstance().getDesktopFrame()) : owner, title,
      Dialog.DEFAULT_MODALITY_TYPE);
    build();
  }
}
