package csbase.client.externalresources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Representa um arquivo no sistema do cliente.
 *
 * @author Tecgraf/PUC-RIO
 */
public interface LocalFile {

  /**
   * Obtm o tamanho do arquivo.
   * @return o tamanho do arquivo.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  long getLength() throws IOException;

  /**
   * Verifica se  possvel ler o arquivo.
   * @return true, se for possvel ler o arquivo, ou false, caso contrrio.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  boolean canRead() throws IOException;

  /**
   * Verifica se  possvel escrever no arquivo.
   * @return true, se for possvel escrever no arquivo, ou false, caso
   *         contrrio.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  boolean canWrite() throws IOException;

  /**
   * Obtm um fluxo de entrada para leitura do arquivo.
   * @return fluxo de entrada para leitura do arquivo.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  InputStream getInputStream() throws IOException;

  /**
   * Obtm um fluxo de sada para escrita no arquivo.
   * @param append se <code>true</code>, os bytes sero acrescentados ao fim do
   *        arquivo. se <code>false</code>, sero escritos no incio (o arquivo
   *        ser sobrescrito).
   * @return fluxo de sada para escrita no arquivo.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  OutputStream getOutputStream(boolean append) throws IOException;

  /**
   * Obtm o nome do arquivo.
   * @return O nome do arquivo.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  String getName() throws IOException;

  /**
   * Obtm o caminho completo para o arquivo, incluindo seu nome.
   * @return O caminho absoluto para o arquivo.
   * @throws IOException Caso ocorra algum erro durante o procedimento.
   */
  String getAbsolutePath() throws IOException;

  /**
   * Verifica se o arquivo existe no sistema de arquivos.
   * @return <code>true</code> se o arquivo for encontrado no sistema de
   *         arquivos.
   */
  boolean exists();
}