package csbase.login;

import java.util.Properties;
import java.util.Vector;

import tecgraf.javautils.core.properties.PropertiesUtils;
import tecgraf.javautils.core.properties.PropertyException;

import csbase.logic.User;
import csbase.server.plugin.service.loginservice.ILoginService;

import br.com.petrobras.cenpes.te.marlim.ValidaAcesso;

/**
 * Protocolo CA para login do CSBase
 *
 * @author Tecgraf
 */
public class CALoginProtocol implements ILoginService {

  /** Verso da biblioteca CA */  
  private int version;
  /**
   * {@inheritDoc}
   */
  @Override
  public LoginProtocol getProtocolType() {
    return LoginProtocol.PROTOCOL_CA;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setProperties(Properties pluginProperties) {
    try {
      version = PropertiesUtils.getIntValue(pluginProperties, "CAVersion");
    } catch (PropertyException e) {
      e.printStackTrace();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public User authenticate(User user, String password) {
    // Atualmente s suportamos CAv3.
    // No futuro, a propriedade version dever ser verificada.
    return authenticateCAv3(user, password);
  }

  /**
   * Autentica o usurio utilizando a biblioteca CAv3
   *
   * @param user - Login do usurio
   * @param password - Senha do usurio
   * @return o usurio autenticado ou nulo em caso de falha
   */
  public User authenticateCAv3(User user, String password) {
    if (ValidaAcesso.Autenticacao(user.getLogin(), password))
      return user;
    return null;
  }
}
