package Requests.Algorithms;

import Requests.User.User;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Algorithm   {
	private String id = null;
	private String name = null;
  private List<String> categories = null;
	private User whoCreated = null;
	private AlgorithmVersion lastVersion = null;
	private List<AlgorithmVersion> versions = new ArrayList<AlgorithmVersion>();
	public Algorithm id(String id) {
		this.id = id;
		return this;
	}
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	public Algorithm name(String name) {
		this.name = name;
		return this;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

  public Algorithm categories(List<String> categories) {
    this.categories = categories;
		return this;
	}

  public List<String> getCategories() {
		return categories;
	}

  public void setCategories(List<String> categories) {
    this.categories = categories;
	}
	public Algorithm whoCreated(User whoCreated) {
		this.whoCreated = whoCreated;
		return this;
	}
	public User getWhoCreated() {
		return whoCreated;
	}
	public void setWhoCreated(User whoCreated) {
		this.whoCreated = whoCreated;
	}
	public Algorithm lastVersion(AlgorithmVersion lastVersion) {
		this.lastVersion = lastVersion;
		return this;
	}
	public AlgorithmVersion getLastVersion() {
		return lastVersion;
	}
	public void setLastVersion(AlgorithmVersion lastVersion) {
		this.lastVersion = lastVersion;
	}
	public Algorithm versions(List<AlgorithmVersion> versions) {
		this.versions = versions;
		return this;
	}
	public Algorithm addVersionsItem(AlgorithmVersion versionsItem) {
		this.versions.add(versionsItem);
		return this;
	}
	public List<AlgorithmVersion> getVersions() {
		return versions;
	}
	public void setVersions(List<AlgorithmVersion> versions) {
		this.versions = versions;
	}

	@Override
	public boolean equals(java.lang.Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		Algorithm algorithm = (Algorithm) o;
		return Objects.equals(this.id, algorithm.id) &&
				Objects.equals(this.name, algorithm.name) &&
				Objects.equals(this.categories, algorithm.categories) &&
				Objects.equals(this.whoCreated, algorithm.whoCreated) &&
				Objects.equals(this.lastVersion, algorithm.lastVersion) &&
				Objects.equals(this.versions, algorithm.versions);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, name, categories, whoCreated, lastVersion, versions);
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("class Algorithm {\n");
		sb.append("    id: ").append(toIndentedString(id)).append("\n");
		sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    categories: ").append(toIndentedString(categories)).append("\n");
		sb.append("    whoCreated: ").append(toIndentedString(whoCreated)).append("\n");
		sb.append("    lastVersion: ").append(toIndentedString(lastVersion)).append("\n");
		sb.append("    versions: ").append(toIndentedString(versions)).append("\n");
		sb.append("}");
		return sb.toString();
	}

	private String toIndentedString(java.lang.Object o) {
		if (o == null) {
			return "null";
		}
		return o.toString().replace("\n", "\n    ");
	}
}

