/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.drmaa2.v1;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.CommandPersistenceServiceInterface;
import csbase.remote.ProjectServiceInterface;
import csbase.remote.SchedulerServiceInterface;
import csbase.rest.adapter.drmaa2.v1.JobInfoMonitor;
import csbase.rest.adapter.drmaa2.v1.JobStateListener;
import csbase.rest.adapter.drmaa2.v1.JobTemplateValidator;
import csbase.rest.adapter.drmaa2.v1.LocalCache;
import csbase.server.plugin.service.commandpersistenceservice.ICommandStatusListener;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import ibase.common.ServiceAdapter;
import ibase.common.ServiceUtil;
import ibase.exception.InternalServiceException;
import ibase.rest.api.drmaa2.v1.adapter.Drmaa2ServiceAdapter;
import ibase.rest.api.drmaa2.v1.adapter.JobDAO;
import ibase.rest.api.drmaa2.v1.adapter.JobMonitorListener;
import ibase.rest.api.drmaa2.v1.factories.Drmaa2DAOFactory;
import ibase.rest.model.drmaa2.v1.Job;
import ibase.rest.model.drmaa2.v1.JobSession;
import ibase.rest.model.drmaa2.v1.JobTemplate;
import ibase.rest.model.drmaa2.v1.StatusType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import tecgraf.javautils.core.timestamp.TStamp32;

public class CSBaseDrmaa2ServiceAdapter
implements Drmaa2ServiceAdapter {
    public static final String RESOURCE_BUNDLE = "CSBaseDrmaa2ServiceAdapter";
    private final JobStateListener jobStateListener;
    private final JobInfoMonitor jobInfoMonitor;
    private final LocalCache<String, Job> localCache;
    private final long cacheTime = 300000L;

    private JobDAO getJobDAO() {
        Drmaa2DAOFactory factory = (Drmaa2DAOFactory)ServiceAdapter.getDAOFactory(Drmaa2DAOFactory.class);
        if (factory == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("job.dao.not.found", new String[0]);
            throw new InternalServiceException(message);
        }
        return factory.getJobDAO();
    }

    private boolean isUnique(String sessionName) {
        return !this.getJobDAO().containsJobSession(sessionName);
    }

    private String generateUniqueSessionName(String userId) {
        return String.format("%s@%s", userId, new TStamp32().toString());
    }

    private ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, this.getClass().getClassLoader());
        return bundle;
    }

    private Job.ExitStatusEnum getExitStatus(CommandFinalizationType type, FailureFinalizationType cause) {
        switch (type) {
            case END: 
            case NO_EXIT_CODE: {
                return Job.ExitStatusEnum.UNKNOWN;
            }
            case SUCCESS: {
                return Job.ExitStatusEnum.SUCCESS;
            }
            case EXECUTION_ERROR: {
                return Job.ExitStatusEnum.EXECUTION_ERROR;
            }
            case FAILED: {
                switch (cause) {
                    case UNKNOWN: {
                        return Job.ExitStatusEnum.UNKNOWN;
                    }
                    case COMMAND_IDENTIFIER_NOT_FOUND: {
                        return Job.ExitStatusEnum.JOB_IDENTIFIER_NOT_FOUND;
                    }
                    case SGA_EXECUTION_ERROR: {
                        return Job.ExitStatusEnum.UNEXPECTED_MACHINE_ERROR;
                    }
                    case FAILED_SETUP_EXECUTION_ENVIRONMENT: {
                        return Job.ExitStatusEnum.FAILED_SETUP_EXECUTION_ENVIRONMENT;
                    }
                    case NO_SGA_AVAILABLE_TO_ROOT_COMMAND: 
                    case SGA_IS_NOT_AVAILABLE: {
                        return Job.ExitStatusEnum.NO_MACHINE_AVAILABLE;
                    }
                    case PROJECT_NOT_FOUND: {
                        return Job.ExitStatusEnum.PROJECT_NOT_FOUND;
                    }
                    case USER_WITHOUT_PERMISSION_FOR_EXECUTION: {
                        return Job.ExitStatusEnum.NO_PERMISSION;
                    }
                }
            }
            case KILLED: {
                return Job.ExitStatusEnum.KILLED;
            }
            case LOST: {
                return Job.ExitStatusEnum.LOST;
            }
        }
        return Job.ExitStatusEnum.UNDEFINED;
    }

    private Job updateJobInfo(CommandInfo cmdInfo, Job job) {
        job.setState(this.getJobState(cmdInfo));
        CommandFinalizationInfo finalizationInfo = cmdInfo.getFinalizationInfo();
        if (finalizationInfo != null) {
            job.setExitCode(finalizationInfo.getExitCode());
            job.setExitStatus(this.getExitStatus(finalizationInfo.getFinalizationType(), finalizationInfo.getFailureCause()));
            job.setCpuTime(cmdInfo.getCpuTimeSec());
            job.setWallclockTime(cmdInfo.getWallTimeSec());
            job.setExecutionMachine(cmdInfo.getSGAName() != null ? cmdInfo.getSGAName() : "");
            job.setRamMemory(cmdInfo.getRAMMemoryMB());
        }
        return job;
    }

    private void printDetailedJobInfo(CommandInfo cmdInfo) {
        System.out.println("---- DADOS DETALHADOS DO JOB " + cmdInfo.getId() + " ----");
        System.out.println("---- CpuTimeSec: " + cmdInfo.getCpuTimeSec());
        System.out.println("---- CpuPerc: " + cmdInfo.getCpuPerc());
        System.out.println("---- WallTimeSec: " + cmdInfo.getWallTimeSec());
        System.out.println("---- BytesInKB: " + cmdInfo.getBytesInKB());
        System.out.println("---- BytesOutKB: " + cmdInfo.getBytesOutKB());
        System.out.println("---- DiskBytesReadKB: " + cmdInfo.getDiskBytesReadKB());
        System.out.println("---- DiskBytesWriteKB: " + cmdInfo.getDiskBytesWriteKB());
        System.out.println("---- GlobalPosition: " + cmdInfo.getGlobalPosition());
        System.out.println("---- Priority: " + cmdInfo.getPriority());
        System.out.println("---- RAMMemoryMB: " + cmdInfo.getRAMMemoryMB());
        System.out.println("---- RAMMemoryPerc: " + cmdInfo.getRAMMemoryPerc());
        System.out.println("---- SwapMemoryMB: " + cmdInfo.getSwapMemoryMB());
        System.out.println("---- SwapMemoryPerc: " + cmdInfo.getSwapMemoryPerc());
        System.out.println("---- UserTimeSec: " + cmdInfo.getUserTimeSec());
    }

    private StatusType getJobState(CommandInfo cmdInfo) {
        CommandStatus cmdStatus = cmdInfo.getStatus();
        if (cmdInfo.isQueued()) {
            return StatusType.QUEUED;
        }
        switch (cmdStatus) {
            case INIT: 
            case SCHEDULED: {
                return StatusType.SCHEDULED;
            }
            case UPLOADING: {
                return StatusType.UPLOADING;
            }
            case EXECUTING: {
                return StatusType.EXECUTING;
            }
            case DOWNLOADING: {
                return StatusType.DOWNLOADING;
            }
            case FINISHED: {
                return StatusType.FINISHED;
            }
        }
        return StatusType.UNKNOWN;
    }

    CSBaseDrmaa2ServiceAdapter() {
        CommandPersistenceService persistenceService = CommandPersistenceService.getInstance();
        this.jobStateListener = new JobStateListener(this.getJobDAO());
        this.localCache = new LocalCache(300000L);
        this.jobStateListener.addJobMonitorLister(new JobMonitorListener(){

            public void statusChanged(Job job) {
                CSBaseDrmaa2ServiceAdapter.this.localCache.put(job.getJobId(), job);
            }

            public void infoChanged(List<Job> jobs) {
                jobs.stream().forEach(job -> CSBaseDrmaa2ServiceAdapter.this.localCache.put(job.getJobId(), job));
            }
        });
        persistenceService.addCommandStatusListener((ICommandStatusListener)this.jobStateListener);
        this.jobInfoMonitor = new JobInfoMonitor(this.getJobDAO());
    }

    public void setLocale(Locale locale) {
        ClientRemoteLocator.administrationService.setLocale(locale);
    }

    public JobSession createJobSession(String sessionName) {
        if (!this.isUnique(sessionName)) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("createJobSession.name.exists.error", new String[]{sessionName});
            throw new InternalServiceException(message);
        }
        String currentUser = ServiceAdapter.getCurrenUser();
        sessionName = sessionName == null ? this.generateUniqueSessionName(currentUser) : sessionName;
        JobSession jobSession = new JobSession();
        jobSession.setSessionName(sessionName);
        this.getJobDAO().insertJobSession(jobSession);
        return jobSession;
    }

    public JobSession getJobSession(String name) {
        return this.getJobDAO().findJobSessionById(name);
    }

    public List<JobSession> getAllJobSessions() {
        return this.getJobDAO().findAllJobSessions();
    }

    public String runJob(String jobSessionId, JobTemplate jobTemplate) {
        List candidateMachines;
        Boolean emailOnTerminated;
        if (jobTemplate == null) {
            String message = ServiceUtil.getTranslator((ResourceBundle)this.getBundle(ClientRemoteLocator.administrationService.getCurrentLocale())).message("runJob.jobtemplate.missing.error", new String[0]);
            throw new InternalServiceException(message);
        }
        JobTemplateValidator validator = new JobTemplateValidator(ServiceAdapter.getCurrenUser(), jobTemplate, ClientRemoteLocator.administrationService.getCurrentLocale());
        AlgorithmConfigurator configurator = validator.getAlgorithmConfigurator();
        CommandSubmission submission = new CommandSubmission(configurator, validator.getProjectId());
        submission.setDescription(jobTemplate.getDescription());
        submission.setPriority(Priority.values()[jobTemplate.getPriority()]);
        List emails = jobTemplate.getEmail();
        if (emails != null) {
            submission.setEmailList(emails.toArray(new String[0]));
        }
        if ((emailOnTerminated = jobTemplate.getEmailOnTerminated()) != null) {
            submission.setMailAtEnd(emailOnTerminated.booleanValue());
        }
        if ((candidateMachines = jobTemplate.getCandidateMachines()) != null && candidateMachines.size() > 0) {
            submission.configureSimpleExecution((String)candidateMachines.get(0));
        }
        Set commandInfos = null;
        SchedulerServiceInterface schedulerService = ClientRemoteLocator.schedulerService;
        try {
            commandInfos = schedulerService.submitCommand(submission);
        }
        catch (Throwable e) {
            throw new InternalServiceException(e);
        }
        CommandInfo cmdInfo = commandInfos.toArray(new CommandInfo[0])[0];
        return cmdInfo.getId();
    }

    public Job getJob(String jobId) {
        Job job = this.getJobDAO().findJobById(jobId);
        return job;
    }

    public List<Job> getJobs(String projectId, Long modifiedAfter) {
        List allJobs = null;
        if ((projectId == null || projectId.isEmpty()) && modifiedAfter == null) {
            return this.getJobDAO().findAllJobs();
        }
        allJobs = this.getJobDAO().findJobs(projectId, modifiedAfter);
        return allJobs;
    }

    public Collection<Job> getLastJobs(Long modifiedAfter, String projectId, String jobId) {
        long currentTime = System.currentTimeMillis();
        if (currentTime < modifiedAfter + 300000L) {
            return this.localCache.valuesAfter(modifiedAfter).stream().filter(j -> {
                if (jobId != null) {
                    return j.getJobId().equals(jobId);
                }
                if (projectId != null) {
                    return j.getProjectId().equals(projectId);
                }
                return true;
            }).collect(Collectors.toList());
        }
        if (jobId != null) {
            LocalDateTime after = LocalDateTime.ofInstant(Instant.ofEpochMilli(modifiedAfter), ZoneId.systemDefault());
            Job job = this.getJobDAO().findJobById(jobId);
            if (job != null && LocalDateTime.parse(job.getLastModifiedTime()).isAfter(after)) {
                return Collections.singletonList(job);
            }
            return new ArrayList<Job>();
        }
        return this.getJobDAO().findJobs(projectId, modifiedAfter);
    }

    public StringBuffer getLogFile(String jobId) {
        CommandPersistenceServiceInterface commandService = ClientRemoteLocator.commandPersistenceService;
        Job job = this.getJobDAO().findJobById(jobId);
        String projectId = ServiceUtil.decodeFromBase64((String)job.getProjectId());
        try {
            CommandInfo cmdInfo = commandService.getCommandInfo((Object)projectId, job.getJobId());
            Set files = cmdInfo.getConfigurator().getStandardOutputFiles();
            return this.logOutputFile(files, projectId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer logOutputFile(Set<FileURLValue> stdOutputFiles, Object projectId) {
        ProjectServiceInterface projectService = ClientRemoteLocator.projectService;
        StringWriter sw = new StringWriter();
        PrintWriter printWriter = new PrintWriter(sw);
        for (FileURLValue stdOutputFile : stdOutputFiles) {
            String[] stdOutputFilePath = stdOutputFile.getPathAsArray();
            InputStream fileFrom = null;
            try {
                if (stdOutputFiles.size() > 1) {
                    printWriter.printf("\n---- %s ----\n", stdOutputFile.getPath());
                }
                if (!projectService.existsFile(projectId, stdOutputFilePath)) continue;
                ClientProjectFile file = projectService.getChild(projectId, stdOutputFilePath);
                InputStream inputStream = file.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String line = bufferedReader.readLine();
                while (line != null) {
                    printWriter.println(line);
                    line = bufferedReader.readLine();
                }
                printWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fileFrom != null) {
                        fileFrom.close();
                    }
                    printWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sw.getBuffer();
    }

    public void addJobMonitorListener(JobMonitorListener listener) {
        this.jobStateListener.addJobMonitorLister(listener);
        this.jobInfoMonitor.addJobMonitorListener(listener);
    }

    public void removeJobMonitorListener(JobMonitorListener listener) {
        this.jobStateListener.removeJobMonitorLister(listener);
        this.jobInfoMonitor.removeJobMonitorListener(listener);
    }
}

