/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.ProgressData;
import csbase.server.services.administrationservice.AdministrationService;
import ibase.common.ServiceUtil;
import ibase.rest.model.job.v1.Job;
import ibase.rest.model.job.v1.MonitoredFile;
import ibase.rest.model.job.v1.StatusChangeHistory;
import ibase.rest.model.job.v1.StatusType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class JobUtils {
    public static Job createJob(CommandInfo commandInfo) {
        try {
            CommandStatus status = commandInfo.getStatus();
            Job job = new Job();
            job.setJobId(commandInfo.getId());
            job.setGroupId(commandInfo.getGroupId());
            String projectId = ServiceUtil.encodeToBase64((String)((String)commandInfo.getProjectId()));
            job.setAlgorithmId(commandInfo.getConfigurator().getAlgorithmId());
            if (commandInfo.getConfigurator().getAlgorithmVersionId() != null) {
                job.setAlgorithmVersion(commandInfo.getConfigurator().getAlgorithmVersionId().toString());
                job.setAlgorithmName(commandInfo.getConfigurator().getAlgorithmName());
            }
            job.setAutomaticallyMachineSelection(Boolean.valueOf(commandInfo.isAutomatic()));
            job.setCpuTime(commandInfo.getCpuTimeSec());
            job.setDescription(commandInfo.getDescription());
            if (status == CommandStatus.FINISHED) {
                job.setEndTime(LocalDateTime.now().toString());
            }
            job.setExecutionMachine(status == CommandStatus.SCHEDULED && commandInfo.getSGAName() != null ? commandInfo.getSGAName() : "");
            if (status == CommandStatus.FINISHED && commandInfo.getFinalizationInfo() != null && commandInfo.getFinalizationInfo().getFinalizationType() != CommandFinalizationType.NO_EXIT_CODE) {
                job.setExitCode(commandInfo.getFinalizationInfo().getExitCode());
            }
            if (status == CommandStatus.FINISHED && commandInfo.getFinalizationInfo() != null) {
                job.setExitStatus(JobUtils.getExitStatus(commandInfo.getFinalizationInfo().getFinalizationType()));
            }
            String userId = (String)commandInfo.getUserId();
            job.setJobOwner(userId);
            AdministrationService service = AdministrationService.getInstance();
            String jobOwnerName = service.getUser((Object)userId).getName();
            job.setJobOwnerName(jobOwnerName);
            job.setPriority(Integer.valueOf(commandInfo.getPriority().ordinal()));
            job.setProjectId(projectId);
            job.setRamMemory(commandInfo.getRAMMemoryMB());
            job.setSessionId((String)commandInfo.getProjectId());
            ProgressData progressData = commandInfo.getProgressData();
            if (progressData != null) {
                job.setProgressInfo(progressData.getDescription());
            }
            StatusType currentStatus = JobUtils.getCurrentStatus(status);
            job.setState(currentStatus);
            ArrayList<StatusChangeHistory> statusHistory = new ArrayList<StatusChangeHistory>();
            StatusChangeHistory statusChangeHistory = new StatusChangeHistory();
            statusChangeHistory.setStatus(currentStatus);
            statusChangeHistory.setTimestamp(LocalDateTime.now().toString());
            statusHistory.add(statusChangeHistory);
            job.setStatusHistory(statusHistory);
            job.setSubmissionMachine(commandInfo.getSGAName() != null ? commandInfo.getSGAName() : "");
            job.setSubmissionTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(commandInfo.getSubmittedDate().getTime()), ZoneId.systemDefault()).toString());
            job.setWallclockTime(commandInfo.getWallTimeSec());
            job.setLastModifiedTime(LocalDateTime.now().toString());
            job.setMonitoredFiles(commandInfo.getMonitoredFiles().stream().map(monitoredFile -> {
                MonitoredFile file = new MonitoredFile();
                file.setName(monitoredFile.getFileName());
                file.setId(ServiceUtil.encodeToBase64((String)monitoredFile.getFileName()));
                file.setFormats(Arrays.asList(monitoredFile.getFormats()));
                return file;
            }).collect(Collectors.toList()));
            return job;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Job updateJob(Job job, CommandInfo commandInfo) {
        try {
            CommandStatus status = commandInfo.getStatus();
            job.setCpuTime(commandInfo.getCpuTimeSec());
            if (status == CommandStatus.FINISHED) {
                job.setEndTime(LocalDateTime.now().toString());
            }
            job.setExecutionMachine(commandInfo.getStatus() != CommandStatus.SCHEDULED && commandInfo.getSGAName() != null ? commandInfo.getSGAName() : "");
            if (status == CommandStatus.FINISHED && commandInfo.getFinalizationInfo() != null && commandInfo.getFinalizationInfo().getFinalizationType() != CommandFinalizationType.NO_EXIT_CODE) {
                job.setExitCode(commandInfo.getFinalizationInfo().getExitCode());
            }
            if (status == CommandStatus.FINISHED && commandInfo.getFinalizationInfo() != null) {
                job.setExitStatus(JobUtils.getExitStatus(commandInfo.getFinalizationInfo().getFinalizationType()));
            }
            job.setPriority(Integer.valueOf(commandInfo.getPriority().ordinal()));
            job.setRamMemory(commandInfo.getRAMMemoryMB());
            StatusType currentStatus = JobUtils.getCurrentStatus(status);
            job.setState(currentStatus);
            List statusHistory = job.getStatusHistory();
            StatusChangeHistory statusChangeHistory = new StatusChangeHistory();
            statusChangeHistory.setStatus(currentStatus);
            statusChangeHistory.setTimestamp(LocalDateTime.now().toString());
            statusHistory.add(statusChangeHistory);
            ProgressData progressData = commandInfo.getProgressData();
            if (progressData != null) {
                job.setProgressInfo(progressData.getDescription());
            }
            job.setWallclockTime(commandInfo.getWallTimeSec());
            job.setMonitoredFiles(commandInfo.getMonitoredFiles().stream().map(monitoredFile -> {
                MonitoredFile file = new MonitoredFile();
                file.setName(monitoredFile.getFileName());
                file.setId(ServiceUtil.encodeToBase64((String)monitoredFile.getFileName()));
                file.setFormats(Arrays.asList(monitoredFile.getFormats()));
                return file;
            }).collect(Collectors.toList()));
            job.setLastModifiedTime(LocalDateTime.now().toString());
            return job;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Job.ExitStatusEnum getExitStatus(CommandFinalizationType finalizationType) {
        switch (finalizationType) {
            case END: {
                return Job.ExitStatusEnum.UNDEFINED;
            }
            case KILLED: {
                return Job.ExitStatusEnum.KILLED;
            }
            case SUCCESS: {
                return Job.ExitStatusEnum.SUCCESS;
            }
            case LOST: {
                return Job.ExitStatusEnum.LOST;
            }
        }
        return Job.ExitStatusEnum.UNKNOWN;
    }

    private static StatusType getCurrentStatus(CommandStatus status) {
        switch (status) {
            case SCHEDULED: {
                return StatusType.SCHEDULED;
            }
            case INIT: {
                return StatusType.INIT;
            }
            case UPLOADING: {
                return StatusType.UPLOADING;
            }
            case EXECUTING: {
                return StatusType.EXECUTING;
            }
            case DOWNLOADING: {
                return StatusType.DOWNLOADING;
            }
            case FINISHED: {
                return StatusType.FINISHED;
            }
        }
        return StatusType.UNKNOWN;
    }
}

