/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.DAO;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class PersistentObject<T>
implements Serializable {
    private Class<T> clazz;
    private T object;
    private String path;

    public PersistentObject(String path, Class<T> clazz) {
        this.clazz = clazz;
        this.path = path;
        this.load();
    }

    private void instantiateT(Class<T> clazz) {
        try {
            this.object = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public T get() {
        return this.object;
    }

    public void set(T object) {
        this.object = object;
    }

    public String getPath() {
        return this.path;
    }

    public Class<T> getClazz() {
        return this.clazz;
    }

    public boolean save() {
        try {
            File file = new File(this.path);
            FileOutputStream fStream = new FileOutputStream(file);
            this.serialize(new BufferedOutputStream(fStream), this.object);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void serialize(OutputStream out, T value) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(value);
        oos.flush();
    }

    public synchronized boolean load() {
        File file = new File(this.path);
        if (!file.exists()) {
            this.instantiateT(this.clazz);
            return false;
        }
        try {
            this.object = this.deserialize(new BufferedInputStream(new FileInputStream(file)));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.instantiateT(this.clazz);
            return false;
        }
    }

    private T deserialize(InputStream in) throws IOException {
        try {
            ObjectInputStream in2 = new ObjectInputStream(in);
            return (T)in2.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }
}

