/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1.parameters;

import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.FileListParameter;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import ibase.common.v2.ServiceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JobParameter {
    private static String ROOT = "root";
    private static String PATH_KEY = "path";
    private static String ID_KEY = "id";
    private String name;
    private Object value;
    private String parameterType;

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public String getParameterType() {
        return this.parameterType;
    }

    public JobParameter(SimpleParameter p, Boolean jsonFormat) {
        this.name = p.getName();
        this.parameterType = p.getType();
        this.value = jsonFormat != false ? p.getValueAsJSON() : this.convertToTextValue(p);
    }

    public JobParameter(SimpleParameter p) {
        this(p, false);
    }

    private Object convertToTextValue(SimpleParameter p) {
        if (p.getValue() == null) {
            return null;
        }
        List<Object> paramValue = new ArrayList<HashMap<String, String>>();
        if (p instanceof EnumerationListParameter) {
            paramValue = ((List)((EnumerationListParameter)EnumerationListParameter.class.cast(p)).getValue()).stream().map(EnumerationItem::getId).collect(Collectors.toList());
        } else if (p instanceof FileParameter) {
            paramValue.add(this.buildPathObject(((FileURLValue)((FileParameter)FileParameter.class.cast(p)).getValue()).getPath()));
        } else if (p instanceof FileListParameter) {
            paramValue = ((List)((FileListParameter)FileListParameter.class.cast(p)).getValue()).stream().map(fp -> this.buildPathObject(fp.getPath())).collect(Collectors.toList());
        } else if (p instanceof ListParameter) {
            paramValue = (List)List.class.cast(((ListParameter)ListParameter.class.cast(p)).getValue());
        } else if (p instanceof TableParameter) {
            Map tab = ((TableParameter)TableParameter.class.cast(p)).exportValue();
            List rows = (List)tab.get(p.getName());
            for (Object[] row : rows) {
                paramValue.add(row);
            }
        } else {
            paramValue.add(p.getValueAsText());
        }
        return paramValue;
    }

    private HashMap<String, String> buildPathObject(String path) {
        HashMap<String, String> pathObj = new HashMap<String, String>();
        pathObj.put(PATH_KEY, path);
        if (path.equals(".")) {
            pathObj.put(ID_KEY, ROOT);
        } else {
            pathObj.put(ID_KEY, ServiceUtil.encodeToBase64((String)path));
        }
        return pathObj;
    }
}

