/*
 * Decompiled with CFR 0.152.
 */
package csbase.rest.adapter.job.v1;

import csbase.logic.algorithms.flows.FlowLink;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.LinkParameter;
import csbase.rest.adapter.job.v1.FlowStructureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FlowStructureValidator {
    public static boolean cycleFreeFlowGraph(Set<FlowNode> nodes, Set<FlowLink> links) {
        HashMap<Integer, Integer> numberOfEntryLinks = new HashMap<Integer, Integer>(nodes.size());
        LinkedList<Object> emptyEntryLinks = new LinkedList<Object>();
        HashMap neighborList = new HashMap(nodes.size());
        if (!FlowStructureValidator.validFlowStructure(nodes, links)) {
            throw new FlowStructureException("Flow contains invalid structure");
        }
        for (FlowNode flowNode : nodes) {
            int nodeId = flowNode.getId();
            neighborList.put(nodeId, new ArrayList());
            numberOfEntryLinks.put(nodeId, 0);
        }
        for (FlowLink flowLink : links) {
            int originNodeId = flowLink.getInput().getNodeId();
            int destinyNodeId = flowLink.getOutput().getNodeId();
            numberOfEntryLinks.put(destinyNodeId, (Integer)numberOfEntryLinks.get(destinyNodeId) + 1);
            ((ArrayList)neighborList.get(originNodeId)).add(destinyNodeId);
        }
        for (Map.Entry entry : numberOfEntryLinks.entrySet()) {
            if (!((Integer)entry.getValue()).equals(0)) continue;
            emptyEntryLinks.add(entry.getKey());
        }
        int chosenNodes = 0;
        while (!emptyEntryLinks.isEmpty()) {
            int n = (Integer)emptyEntryLinks.pop();
            ++chosenNodes;
            Iterator iterator = ((ArrayList)neighborList.get(n)).iterator();
            while (iterator.hasNext()) {
                int nodeId = (Integer)iterator.next();
                numberOfEntryLinks.put(nodeId, (Integer)numberOfEntryLinks.get(nodeId) - 1);
                if (!((Integer)numberOfEntryLinks.get(nodeId)).equals(0)) continue;
                emptyEntryLinks.add(nodeId);
            }
        }
        return chosenNodes == nodes.size();
    }

    public static boolean validFlowStructure(Set<FlowNode> nodes, Set<FlowLink> links) {
        HashMap<Integer, FlowNode> existingNodes = new HashMap<Integer, FlowNode>(nodes.size());
        for (FlowNode node : nodes) {
            existingNodes.put(node.getId(), node);
        }
        for (FlowLink link : links) {
            boolean validIds;
            LinkParameter source = link.getInput();
            LinkParameter target = link.getOutput();
            if (source == null || target == null) {
                return false;
            }
            int sourceId = source.getNodeId();
            int targetId = target.getNodeId();
            boolean bl = validIds = existingNodes.containsKey(sourceId) && existingNodes.containsKey(targetId);
            if (validIds && sourceId != targetId) continue;
            return false;
        }
        return true;
    }
}

