/*
 * $Id: MonitoredDirectory.java 117411 2011-04-19 14:38:47Z clinio $
 */

package csbase.server.services.diskusageservice;

import java.io.File;

/**
 * Entidade de monitorao do servio.
 * 
 * @author Tecgraf/PUC-Rio
 */
class MonitoredDirectory {

  /**
   * Diretrio a ser analisado.
   */
  final private File directory;

  /**
   * Identificador
   */
  final private String id;

  /**
   * Construtor
   * 
   * @param id identificador.
   * @param dirPath path do diretrio a ser monitorado.
   */
  public MonitoredDirectory(final String id, final String dirPath) {
    final File dir = new File(dirPath);
    this.id = id;
    this.directory = dir;
  }

  /**
   * @return o campo id
   */
  final String getId() {
    return id;
  }

  /**
   * Consulta o diretrio a ser monitorado.
   * 
   * @return o diretrio
   */
  final File getDirectory() {
    return directory;
  }

  /**
   * Indicativo de que rea  consistente (diretrio).
   * 
   * @return indicativo
   */
  final boolean isConsistent() {
    if (directory.exists() && !directory.isDirectory()) {
      return false;
    }
    return true;
  }

  /**
   * Indicativo de que o diretrio est disponvel para aquisio de dados.
   * 
   * @return indicativo
   */
  final boolean isAvailable() {
    if (!directory.exists()) {
      return false;
    }
    if (!directory.canRead()) {
      return false;
    }
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    final String fmt = "rea de disco %s: %s";
    final String path = directory.getAbsolutePath();
    final String txt = String.format(fmt, id, path);
    return txt;
  }
}
