/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_02;

import tecgraf.openbus.data_service.core.v1_02.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_02.DataDescription;
import tecgraf.openbus.data_service.core.v1_02.DataNotFound;
import tecgraf.openbus.data_service.core.v1_02.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_02.ServiceFailure;
import tecgraf.openbus.data_service.project.v1_02.IProjectNavigationDataServiceOperations;
import tecgraf.openbus.data_service.project.v1_02.IProjectNavigationDataServicePOA;
import tecgraf.openbus.data_service.project.v1_02.InvalidOwner;
import tecgraf.openbus.data_service.project.v1_02.ProjectDataView;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IProjectNavigationDataServiceServant extends
  IProjectNavigationDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public ProjectDataView[] getProject(String fOwner) throws DataAccessDenied,
    ServiceFailure, InvalidOwner {

    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());

    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IProjectNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getProject(fOwner);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getChildren(byte[] fKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IProjectNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getChildren(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure(e.getMessage());
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription getParent(byte[] fKey) throws ServiceFailure,
    DataNotFound, DataAccessDenied, InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IProjectNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getParent(fKey);
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataDescription[] getRoots() throws ServiceFailure, DataAccessDenied {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());
    try {
      IProjectNavigationDataServiceOperations service =
        ProjectDataService.getInstance();
      return service.getRoots();
    }
    catch (RuntimeException e) {
      Server.logSevereMessage(e.getMessage(), e);
      throw new ServiceFailure();
    }
    finally {
      Service.setUserId(null);
    }
  }
}
