/**
 * $Id: AbstractProactiveMonitor.java 140743 2013-05-09 13:35:50Z fpina $
 */

package csbase.server.services.diagnosticservice.monitors;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.server.services.diagnosticservice.engine.UpdateHandler;

/**
 * Classe abstrata que representa um monitor pr-ativo.
 * 
 * @author Tecgraf
 */
public abstract class AbstractProactiveMonitor extends AbstractMonitor
  implements ProactiveMonitor {
  /**
   * Objeto registrado para atualizar o estado do recurso monitorado
   */
  protected UpdateHandler handler;

  /**
   * Construtor bsico de um monitor pr-ativo.
   * 
   * @param resourceName nome do recurso monitorado
   * 
   * @throws ResourceException caso algum parametro informado na criao do
   *         monitor for invlido
   */
  public AbstractProactiveMonitor(String resourceName) throws ResourceException {
    super(resourceName);
  }

  /**
   * Registra o monitor em um engine.
   * 
   * @param handler {@link csbase.server.services.diagnosticservice.engine.UpdateHandler} no qual
   *        o monitor ir se registrar.
   */
  @Override
  public void registerEngine(UpdateHandler handler) {
    this.handler = handler;
  }
}
