package csbase.server.services.diagnosticservice.monitors.openbus;

import java.util.Locale;

import csbase.logic.diagnosticservice.ResourceException;
import csbase.logic.diagnosticservice.Status;
import csbase.remote.DiagnosticServiceInterface;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.AbstractMonitor;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * Monitorao do barramento Openbus
 * 
 * @author Tecgraf PUC-Rio
 */
public class OpenbusMonitor extends AbstractMonitor {
  /**
   * O host do barramento
   */
  private String host;
  /**
   * A porta do barramento
   */
  private int port;

  /**
   * Construtor.
   * 
   * @throws ResourceException caso algum parmetro seja invlido
   */
  public OpenbusMonitor() throws ResourceException {
    super(DiagnosticServiceInterface.OPENBUS_RESOURCE);
    this.addValidation(new OpenbusServiceValidation());
    if (OpenBusService.getInstance().isEnabled()) {
      this.addValidation(new ConnectionValidation());
      this.addValidation(new RegistryServiceValidation());
      this.host = OpenBusService.getInstance().getBusInfo().getHost();
      this.port = OpenBusService.getInstance().getBusInfo().getPort();
      this.addValidation(new BusVersionValidation(host, port));
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public synchronized Status checkResource(Locale locale)
    throws ResourceException {
    this.cleanProperties();
    this.addProperty(MessageTranslator.getString(
      "server.openbusmonitor.host.label", locale), String.valueOf(this.host),
      "OpenBusService.ACS.hostAddr");
    this.addProperty(MessageTranslator.getString(
      "server.openbusmonitor.port.label", locale), String.valueOf(this.port),
      "OpenBusService.ACS.port");
    this.addProperty(MessageTranslator.getString(
      "server.openbusmonitor.entity.label", locale), OpenBusService
      .getInstance().getEntityName(), "OpenBusService.entity.name");
    //    this.addProperty(MessageTranslator.getString(
    //      "server.openbusmonitor.certificate.label", locale), OpenBusService
    //      .getInstance().getCertificateFilePath(),
    //      "OpenBusService.certificate.file");
    this.addProperty(MessageTranslator.getString(
      "server.openbusmonitor.private.key.label", locale), OpenBusService
      .getInstance().getPrivateKeyFilePath(),
      "OpenBusService.private.key.file ");
    return super.checkResource(locale);
  }
}
