/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.administrationservice;

import csbase.logic.Role;
import csbase.logic.RoleInfo;
import csbase.server.services.administrationservice.DAOException;
import csbase.server.services.administrationservice.RoleDAO;
import csbase.server.services.administrationservice.RoleIO;
import java.util.List;

public class DefaultRoleDAO
implements RoleDAO {
    private RoleIO roleRepository = new RoleIO();

    @Override
    public Role createRole(RoleInfo info) throws DAOException {
        Role role;
        try {
            role = this.roleRepository.writeNew(info);
        }
        catch (Exception e) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "]";
            throw new DAOException(e, operationInfo);
        }
        if (role == null) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "]";
            throw new DAOException("Falha em RoleIO.writeNew", operationInfo);
        }
        return role;
    }

    @Override
    public void deleteRole(Object id) throws DAOException {
        try {
            this.roleRepository.delete(id);
        }
        catch (Exception e) {
            throw new DAOException(e, "id: " + id);
        }
    }

    @Override
    public Role modifyRole(Object id, RoleInfo info) throws DAOException {
        Role role;
        try {
            role = this.roleRepository.write(id, info);
        }
        catch (Exception e) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "] - para o usu\u00e1rio: " + id;
            throw new DAOException(e, operationInfo);
        }
        if (role == null) {
            String operationInfo = "[name: " + info.name + ", desc: " + info.description + "] - para o usu\u00e1rio: " + id;
            throw new DAOException("Falha em RoleIO.write", operationInfo);
        }
        return role;
    }

    @Override
    public List<Role> readAllRoles() throws DAOException {
        try {
            return this.roleRepository.readAll();
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }

    @Override
    public Role readRole(Object id) throws DAOException {
        try {
            return this.roleRepository.read(id);
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
    }
}

