/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.applicationservice;

import csbase.exception.PermissionException;
import csbase.logic.Notification;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationCategory;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.logic.applicationservice.ApplicationRegistryException;
import csbase.logic.applicationservice.ApplicationsReloadNotification;
import csbase.logic.applicationservice.ReloadApplicationsEvent;
import csbase.remote.ApplicationServiceInterface;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.RemoteEvent;
import csbase.remote.TransactionCallbackInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.TransactionManager;
import csbase.server.services.ftcservice.FTCService;
import csbase.server.services.notificationservice.NotificationService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.io.FileUtils;

public final class ApplicationService
extends Service
implements ApplicationServiceInterface {
    private static final String APPLICATIONS_DIR_PROPERTY = "applications.directory";
    private static final String CATEGORIES_DIR_PROPERTY = "categories.directory";
    private static final String REPOSITORY_MONITOR_INTERVAL_PROPERTY = "applications.directory.monitor.interval";
    private final Hashtable<String, ApplicationRegistry> registries = new Hashtable();
    private final Hashtable<String, ApplicationCategory> categories = new Hashtable();
    private TransactionManager transaction;
    private FileAlterationMonitor monitor;
    private final List<Pattern> classLoaderWhiteList = new ArrayList<Pattern>();
    private final List<Pattern> classLoaderBlackList = new ArrayList<Pattern>();
    private final FileFilter directoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            boolean isDir = file.isDirectory();
            String name = file.getName();
            boolean nameOk = !name.startsWith(".");
            return isDir && nameOk;
        }
    };

    private byte[] buildImage(String id, File directory, int size) throws ServerException {
        String err;
        String prefix;
        String path;
        List<String> extensions = this.getStringListProperty("image.extension");
        File file = null;
        for (String ext : extensions) {
            String fileName = id + "." + size + "." + ext;
            File f = new File(directory, fileName);
            if (!f.exists()) continue;
            file = f;
            break;
        }
        if (file == null) {
            path = directory.getAbsolutePath();
            prefix = "N\u00e3o foi localizado \u00edcone de apl./cat. em: ";
            err = "N\u00e3o foi localizado \u00edcone de apl./cat. em: " + path + " - tamanho: " + size;
            Server.logWarningMessage(err);
            return null;
        }
        if (!file.canRead()) {
            path = directory.getAbsolutePath();
            prefix = "Sem permiss\u00e3o de leitura de: ";
            err = "Sem permiss\u00e3o de leitura de: " + path + " - tamanho: " + size;
            throw new ServerException(err);
        }
        path = file.getAbsolutePath();
        long length = file.length();
        if (length >= Integer.MAX_VALUE) {
            String err2 = "\u00cdcone muito grande para apl./cat.: " + path;
            throw new ServerException(err2);
        }
        try {
            int sz = (int)length;
            byte[] array = new byte[sz];
            FileInputStream fStream = new FileInputStream(file);
            fStream.read(array);
            fStream.close();
            return array;
        }
        catch (IOException ioe) {
            String fmt = "Falha de I/O para \u00edcone de aplica\u00e7\u00e3o/categoria: %s";
            String err3 = String.format("Falha de I/O para \u00edcone de aplica\u00e7\u00e3o/categoria: %s", path);
            throw new ServerException(err3, ioe);
        }
    }

    public Hashtable<String, ApplicationCategory> getApplicationCategories() {
        return new Hashtable<String, ApplicationCategory>(this.categories);
    }

    public Hashtable<String, ApplicationRegistry> getApplicationRegistries() {
        return new Hashtable<String, ApplicationRegistry>(this.registries);
    }

    public ApplicationRegistry getApplicationRegistry(String id) {
        return this.registries.get(id);
    }

    private File getApplicationDirectoryForResource(String appId, String[] resourcePath) {
        if (resourcePath == null || resourcePath.length < 1) {
            return null;
        }
        String path = FileUtils.joinPath((String)File.separator, (String[])resourcePath);
        for (String p : resourcePath) {
            if (!p.contains("..")) continue;
            String fmt = "Recusado resource de aplica\u00e7\u00e3o %s com path %s!";
            String err = String.format("Recusado resource de aplica\u00e7\u00e3o %s com path %s!", appId, path);
            Server.logSevereMessage(err);
            return null;
        }
        List<String> repPaths = this.getApplicationRepositories();
        if (repPaths.size() == 0) {
            return null;
        }
        File lastDir = null;
        for (String repPath : repPaths) {
            File repDir = new File(repPath);
            File appDir = new File(repDir, appId);
            File resource = new File(appDir, path);
            if (!resource.exists()) continue;
            lastDir = appDir;
        }
        return lastDir;
    }

    public RemoteFileChannelInfo getApplicationResource(String appId, String[] resourcePath) throws RemoteException {
        File file = this.getApplicationInternalResource(appId, resourcePath);
        if (file == null) {
            return null;
        }
        try {
            FTCService ftcService = FTCService.getInstance();
            Server.logInfoMessage("Criando FileChannelInfo: ApplicationService");
            return ftcService.createFileChannelInfo(file, true);
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private File getApplicationInternalResource(String appId, String[] resourcePath) {
        File parent;
        File directory = this.getApplicationDirectoryForResource(appId, resourcePath);
        if (directory == null || !directory.exists()) {
            return null;
        }
        String path = FileUtils.joinPath((String)File.separator, (String[])resourcePath);
        File file = new File(directory, path);
        if (!file.exists()) {
            return null;
        }
        for (parent = file.getParentFile(); parent != null && !parent.equals(directory); parent = parent.getParentFile()) {
        }
        if (parent == null) {
            return null;
        }
        return file;
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    @Override
    public void initService() throws ServerException {
        this.transaction = new TransactionManager();
        this.loadClassLoaderConfiguration();
        this.loadRepositories();
        this.createRepositoryWatchers();
    }

    private void loadClassLoaderConfiguration() {
        List<String> blackListProperties;
        List<String> whiteListProperties = this.getStringListProperty("classloader.whitelist");
        if (whiteListProperties != null) {
            for (String string : whiteListProperties) {
                Pattern pattern = Pattern.compile(string.trim());
                this.classLoaderWhiteList.add(pattern);
            }
        }
        if ((blackListProperties = this.getStringListProperty("classloader.blacklist")) != null) {
            for (String string : blackListProperties) {
                Pattern pattern = Pattern.compile(string.trim());
                this.classLoaderBlackList.add(pattern);
            }
        }
    }

    private void createRepositoryWatchers() throws ServerException {
        List<String> appPaths = this.getApplicationRepositories();
        long pollingInterval = this.getIntProperty(REPOSITORY_MONITOR_INTERVAL_PROPERTY);
        if (pollingInterval >= 0L) {
            this.monitor = new FileAlterationMonitor(1000L * pollingInterval);
            for (String appPath : appPaths) {
                IOFileFilter hiddenFilesFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"."));
                FileAlterationObserver dirObserver = new FileAlterationObserver(new File(appPath), (FileFilter)hiddenFilesFilter);
                dirObserver.addListener((FileAlterationListener)new ReloadApplicationListener(appPath));
                this.monitor.addObserver(dirObserver);
            }
            try {
                this.monitor.start();
                Server.logInfoMessage("Iniciada a monitora\u00e7\u00e3o de arquivos no reposit\u00f3rio de aplica\u00e7\u00f5es com intervalo de " + pollingInterval + " segundos");
            }
            catch (Exception e) {
                throw new ServerException("Could not start file monitoring on applications repository", e);
            }
        }
    }

    private List<String> getApplicationRepositories() {
        List<String> appPaths = this.getStringListProperty(APPLICATIONS_DIR_PROPERTY);
        return appPaths;
    }

    public boolean reloadApplications() {
        this.checkApplicationsAdminPermission();
        TransactionCallbackInterface cb = new TransactionCallbackInterface(){

            public boolean isAlive() {
                return true;
            }
        };
        String uName = ApplicationService.getUser().getName();
        Server.logInfoMessage("Pedido de recarga de aplica\u00e7\u00f5es vinda de " + uName);
        try {
            if (!this.lock(cb)) {
                Server.logSevereMessage(this.getString("ApplicationService.error.applications.block_reload_failed"));
                return false;
            }
            this.loadRepositories();
            this.unlock(cb);
            Server.logInfoMessage("Recarga de aplicativos efetuada!");
            this.notifyObservers((RemoteEvent)new ReloadApplicationsEvent());
            NotificationService notService = NotificationService.getInstance();
            ApplicationsReloadNotification notification = new ApplicationsReloadNotification(this.getSenderName());
            notService.notifyTo(null, (Notification)notification);
            return true;
        }
        catch (ServerException e) {
            Server.logSevereMessage("Erro ao recarregar aplica\u00e7\u00f5es", e);
            return false;
        }
    }

    private synchronized void loadRepositories() throws ServerException {
        this.registries.clear();
        this.categories.clear();
        this.loadApplicationsFromRepositories();
        this.loadCategoryFromRepository();
        this.checkConfiguration();
    }

    private void checkConfiguration() {
        Collection<ApplicationRegistry> regs = this.registries.values();
        ArrayList<ApplicationRegistry> invalidRegistries = new ArrayList<ApplicationRegistry>();
        for (ApplicationRegistry reg : regs) {
            if (this.isValidRegistry(reg)) continue;
            invalidRegistries.add(reg);
        }
        for (ApplicationRegistry applicationRegistry : invalidRegistries) {
            regs.remove(applicationRegistry);
        }
    }

    private boolean isValidRegistry(ApplicationRegistry reg) {
        try {
            reg.closeConfiguration();
            return true;
        }
        catch (ApplicationRegistryException e) {
            Server.logSevereMessage("Erro no registro da aplica\u00e7\u00e3o " + reg.getId(), e);
            return false;
        }
    }

    private void loadApplication(File appDirectory) throws ServerException {
        List classPath;
        byte[] img32;
        ApplicationRegistry reg;
        String appPath = appDirectory.getAbsolutePath();
        String id = appDirectory.getName();
        ApplicationRegistry preExistant = this.registries.get(id);
        if (preExistant != null) {
            String err = "Detectada redefini\u00e7\u00e3o para aplica\u00e7\u00e3o: " + id;
            Server.logInfoMessage(err);
            reg = preExistant;
        } else {
            reg = new ApplicationRegistry(id, System.currentTimeMillis());
            this.registries.put(id, reg);
        }
        String fileName = id + ".properties";
        File propertyFile = new File(appDirectory, fileName);
        if (!propertyFile.exists()) {
            String fmt = "N\u00e3o foram localizadas novas propriedades em %s";
            String err = String.format("N\u00e3o foram localizadas novas propriedades em %s", appPath);
            Server.logInfoMessage(err);
        } else {
            Properties preLoaded = preExistant != null ? preExistant.getSpecificProperties() : new Properties();
            Properties properties = new Properties(preLoaded);
            try (FileInputStream in = new FileInputStream(propertyFile);){
                properties.load(in);
                reg.setSpecificProperties(properties);
            }
            catch (IOException e) {
                String path = propertyFile.getAbsolutePath();
                String err = "Falha de I/O na defini\u00e7\u00e3o de aplica\u00e7\u00e3o: " + path;
                throw new ServerException(err, e);
            }
        }
        byte[] img16 = this.buildImage(id, appDirectory, 16);
        if (img16 != null) {
            reg.setIconDefinition(img16);
        }
        if ((img32 = this.buildImage(id, appDirectory, 32)) != null) {
            reg.setImageDefinition(img32);
        }
        if ((classPath = reg.getClasspath()) != null && !classPath.isEmpty()) {
            reg.setClasspathBaseDir(appDirectory);
            reg.setClassLoaderWhiteList(this.classLoaderWhiteList);
            reg.setClassLoaderBlackList(this.classLoaderBlackList);
        }
    }

    private void loadApplicationRepository(File appDirectory) throws ServerException {
        File[] directories;
        if (!appDirectory.exists()) {
            String err = "N\u00e3o foi encontrado o diret\u00f3rio de aplica\u00e7\u00f5es: ";
            Server.logWarningMessage("N\u00e3o foi encontrado o diret\u00f3rio de aplica\u00e7\u00f5es: " + appDirectory.getAbsolutePath());
            return;
        }
        if (!appDirectory.isDirectory()) {
            String err = "N\u00e3o \u00e9 diret\u00f3rio (aplica\u00e7\u00f5es): ";
            throw new ServerException("N\u00e3o \u00e9 diret\u00f3rio (aplica\u00e7\u00f5es): " + appDirectory.getAbsolutePath());
        }
        for (File directory : directories = appDirectory.listFiles(this.directoryFilter)) {
            try {
                this.loadApplication(directory);
            }
            catch (ServerException e) {
                Server.logSevereMessage("Erro ao carregar a aplica\u00e7\u00e3o " + directory.getName(), e);
            }
        }
    }

    private synchronized void reloadApplication(String appId) {
        Server.logInfoMessage("Recarregando aplica\u00e7\u00e3o " + appId);
        try {
            if (this.registries.containsKey(appId)) {
                this.registries.remove(appId);
            }
            List<String> repositories = this.getApplicationRepositories();
            for (String repository : repositories) {
                File appDirectory = new File(repository, appId);
                if (!appDirectory.exists()) continue;
                this.loadApplication(appDirectory);
            }
            ApplicationRegistry registry = this.registries.get(appId);
            if (registry != null && !this.isValidRegistry(registry)) {
                this.registries.remove(appId);
            }
        }
        catch (ServerException e) {
            Server.logSevereMessage("Erro ao carregar a aplica\u00e7\u00e3o " + appId, e);
        }
    }

    private final void loadApplicationsIdsForCategory(ApplicationCategory category, Properties properties) throws ServerException {
        String key;
        String v;
        String catId = category.getId();
        boolean noApplicationInside = true;
        int i = 1;
        while ((v = properties.getProperty(key = catId + ".application." + i)) != null) {
            String appId = v.trim();
            Hashtable<String, ApplicationRegistry> regs = this.getApplicationRegistries();
            if (!regs.containsKey(appId)) {
                String fmt = "Cat. de aplica\u00e7\u00f5es <%s> n\u00e3o pode conter aplica\u00e7\u00e3o cujo id \u00e9 <%s> (inexistente). Descartando...";
                String err = String.format("Cat. de aplica\u00e7\u00f5es <%s> n\u00e3o pode conter aplica\u00e7\u00e3o cujo id \u00e9 <%s> (inexistente). Descartando...", category.getId(), appId);
                Server.logSevereMessage(err);
            } else {
                category.addApplicationId(appId);
                noApplicationInside = false;
            }
            ++i;
        }
        if (noApplicationInside) {
            String err = "Categoria de aplica\u00e7\u00f5es vazia: " + catId;
            Server.logSevereMessage(err);
        }
    }

    private void loadCategory(File catDirectory) throws ServerException {
        ApplicationCategory category;
        String id = catDirectory.getName();
        ApplicationCategory existant = this.categories.get(id);
        if (existant != null) {
            String err = "Dupla de defini\u00e7\u00e3o de grupo de applica\u00e7\u00e3o: " + id;
            throw new ServerException(err);
        }
        String fileName = id + ".properties";
        File file = new File(catDirectory, fileName);
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
            byte[] img16 = this.buildImage(id, catDirectory, 16);
            byte[] img32 = this.buildImage(id, catDirectory, 32);
            category = new ApplicationCategory(id, properties, img16, img32);
            this.loadApplicationsIdsForCategory(category, properties);
        }
        catch (IOException e) {
            String path = file.getAbsolutePath();
            String err = "Falha de defini\u00e7\u00e3o de aplica\u00e7\u00e3o: " + path;
            throw new ServerException(err, e);
        }
        this.categories.put(id, category);
        Server.logInfoMessage("Registrado categoria de aplica\u00e7\u00e3o: " + id + ".");
    }

    private void loadApplicationsFromRepositories() throws ServerException {
        List<String> appPaths = this.getApplicationRepositories();
        if (appPaths.size() == 0) {
            Server.logSevereMessage("No application repositories defined!");
        }
        for (String appPath : appPaths) {
            this.loadApplicationsFromRepository(appPath);
        }
        if (this.registries.size() == 0) {
            Server.logWarningMessage("No applications defined!");
        }
    }

    private void loadApplicationsFromRepository(String appPath) throws ServerException {
        File repository = new File(appPath);
        String path = repository.getAbsolutePath();
        Server.logInfoMessage("Carregando reposit\u00f3rio de aplica\u00e7\u00f5es: " + path);
        if (!repository.exists()) {
            String err = "N\u00e3o foi encontrado o reposit\u00f3rio de aplica\u00e7\u00f5es: ";
            throw new ServerException("N\u00e3o foi encontrado o reposit\u00f3rio de aplica\u00e7\u00f5es: " + path);
        }
        if (!repository.isDirectory()) {
            String err = "Reposit\u00f3rio de apps: " + path + " n\u00e3o \u00e9 diret\u00f3rio!";
            throw new ServerException(err);
        }
        this.loadApplicationRepository(repository);
    }

    private void loadCategoryFromRepository() throws ServerException {
        File[] directories;
        String catPath = this.getStringProperty(CATEGORIES_DIR_PROPERTY);
        File repository = new File(catPath);
        String path = repository.getAbsolutePath();
        Server.logInfoMessage("Carregando reposit\u00f3rio de categorias: " + path);
        if (!repository.exists()) {
            String err = "N\u00e3o foi encontrado o diret\u00f3rio de categorias: ";
            Server.logWarningMessage("N\u00e3o foi encontrado o diret\u00f3rio de categorias: " + repository.getAbsolutePath());
            return;
        }
        if (!repository.isDirectory()) {
            String err = "N\u00e3o \u00e9 diret\u00f3rio (categorias): ";
            throw new ServerException("N\u00e3o \u00e9 diret\u00f3rio (categorias): " + repository.getAbsolutePath());
        }
        for (File directory : directories = repository.listFiles(this.directoryFilter)) {
            this.loadCategory(directory);
        }
    }

    @Override
    public void shutdownService() {
        if (this.monitor != null) {
            try {
                this.monitor.stop();
            }
            catch (Exception e) {
                Server.logSevereMessage("Erro ao interromper a monitora\u00e7\u00e3o de arquivos no reposit\u00f3rio de aplica\u00e7\u00f5es", e);
            }
        }
        this.registries.clear();
        this.categories.clear();
    }

    public static void createService() throws ServerException {
        new ApplicationService();
    }

    public static ApplicationService getInstance() {
        String serviceName = "ApplicationService";
        return (ApplicationService)Service.getInstance("ApplicationService");
    }

    protected ApplicationService() throws ServerException {
        super("ApplicationService");
        ClientRemoteLocator.applicationService = this;
    }

    protected ApplicationService(String srvName) throws ServerException {
        super(srvName);
        ClientRemoteLocator.applicationService = this;
    }

    public boolean isLocked() {
        return this.transaction.isLocked();
    }

    public boolean lock(TransactionCallbackInterface cb) {
        this.checkApplicationsAdminPermission();
        return this.transaction.lock(cb);
    }

    public void unlock(TransactionCallbackInterface cb) {
        this.checkApplicationsAdminPermission();
        this.transaction.unlock(cb);
    }

    private void checkApplicationsAdminPermission() {
        User user = Service.getUser();
        if (!user.isAdmin()) {
            throw new PermissionException(this.getString("ApplicationService.error.applications.no_permission"));
        }
    }

    private final class ReloadApplicationListener
    extends FileAlterationListenerAdaptor {
        private final String repositoryPath;

        private ReloadApplicationListener(String repositoryPath) {
            this.repositoryPath = repositoryPath;
        }

        public String[] getApplicationPath(File file) {
            String path = file.getPath();
            String newPath = path.replace(this.repositoryPath, "");
            String[] splitPath = FileUtils.splitPath((String)newPath);
            return splitPath;
        }

        private String getApplicationId(File file) {
            String[] applicationPath = this.getApplicationPath(file);
            if (applicationPath != null && applicationPath.length > 0) {
                return applicationPath[0];
            }
            return null;
        }

        private boolean isInApplicationDirectory(File file) {
            String[] applicationPath = this.getApplicationPath(file);
            return applicationPath.length > 1;
        }

        public void onFileChange(File file) {
            Server.logFineMessage("Arquivo modificado: " + file);
            if (this.isInApplicationDirectory(file)) {
                this.applicationWasUpdated(file);
            }
        }

        public void onDirectoryCreate(File directory) {
            Server.logFineMessage("Diret\u00f3rio adicionado: " + directory);
            if (this.isInApplicationDirectory(directory)) {
                this.applicationWasUpdated(directory);
            }
        }

        public void onDirectoryDelete(File directory) {
            Server.logFineMessage("Diret\u00f3rio removido: " + directory);
            if (this.isInApplicationDirectory(directory)) {
                this.applicationWasUpdated(directory);
            }
        }

        public void onDirectoryChange(File directory) {
            Server.logInfoMessage("Modificado diret\u00f3rio " + directory);
            this.applicationWasUpdated(directory);
        }

        private void applicationWasUpdated(File file) {
            String appId = this.getApplicationId(file);
            if (appId != null) {
                ApplicationService.this.reloadApplication(appId);
            }
        }
    }
}

