/**
 * $Id$
 */
package csbase.server.services.projectservice.v1_01;

import tecgraf.openbus.data_service.core.v1_01.AbsentViews;
import tecgraf.openbus.data_service.core.v1_01.DataAccessDenied;
import tecgraf.openbus.data_service.core.v1_01.DataAlreadyExist;
import tecgraf.openbus.data_service.core.v1_01.DataNotFound;
import tecgraf.openbus.data_service.core.v1_01.InvalidDataKey;
import tecgraf.openbus.data_service.core.v1_01.ServiceFailure;
import tecgraf.openbus.data_service.core.v1_01.UnavailableDataService;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalTransferDataServiceOperations;
import tecgraf.openbus.data_service.hierarchical.v1_01.IHierarchicalTransferDataServicePOA;
import tecgraf.openbus.data_service.hierarchical.v1_01.UnsupportedOperation;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.openbusservice.OpenBusService;

/**
 * 
 * 
 * @author Tecgraf
 */
public class IHierarchicalTransferDataServiceServant extends
  IHierarchicalTransferDataServicePOA {

  /**
   * {@inheritDoc}
   */
  @Override
  public byte[] copyDataFrom(byte[] fSourceKey, byte[] fParentKey)
    throws UnavailableDataService, ServiceFailure, DataAlreadyExist,
    DataNotFound, DataAccessDenied, AbsentViews, UnsupportedOperation,
    InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

    try {
      IHierarchicalTransferDataServiceOperations service =
        ProjectDataService.getInstance();

      return service.copyDataFrom(fSourceKey, fParentKey);
    }
    catch (RuntimeException e) {
      String msg = "Erro na chamada do mtodo copyDataFrom: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void updateDataFrom(byte[] fKey, byte[] fSourceKey)
    throws UnavailableDataService, ServiceFailure, DataNotFound,
    DataAccessDenied, AbsentViews, InvalidDataKey {
    DataValidation.checkUser(OpenBusService.getInstance().getRequesterUserId());
    Service.setUserId(OpenBusService.getInstance().getRequesterUserId());

    try {
      IHierarchicalTransferDataServiceOperations service =
        ProjectDataService.getInstance();

      service.updateDataFrom(fKey, fSourceKey);
    }
    catch (RuntimeException e) {
      String msg =
        "Erro na chamada do mtodo updateDataFrom: " + e.getMessage();
      Server.logSevereMessage(msg, e);
      throw new ServiceFailure(msg);
    }
    finally {
      Service.setUserId(null);
    }
  }
}
